package com.flybits.android.push.worker

import android.app.NotificationManager
import android.content.Context
import android.os.Build
import android.support.v4.app.NotificationManagerCompat
import androidx.work.Worker
import androidx.work.WorkerParameters
import com.flybits.android.push.analytics.NotificationAuthorizationAnalytics
import com.flybits.commons.library.SharedElementsFactory
import com.flybits.commons.library.logging.Logger

class PushWorker(context: Context, workerParameters: WorkerParameters) :
    Worker(context, workerParameters) {
    override fun doWork(): Result {
        return doWork(applicationContext)
    }


    companion object {
        private const val TAG_LOGGING = "PushWorker"
        fun doWork(applicationContext: Context): Result {
            Logger.appendTag(TAG_LOGGING).i("$TAG_LOGGING started")
            val sharedElements = SharedElementsFactory.get(applicationContext)
            sharedElements.getIsPushNotificationEnabled()
            var isPushEnable = false
            val isEnabledOnApp =
                NotificationManagerCompat.from(applicationContext).areNotificationsEnabled()
            val pushChannelId = sharedElements.getNotificationChannel()
            if (pushChannelId.isBlank()) {
                isPushEnable = isEnabledOnApp
            }
            else if (isEnabledOnApp) {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                    (applicationContext.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager)
                        .getNotificationChannel(pushChannelId).let {
                            isPushEnable = it.importance != NotificationManager.IMPORTANCE_NONE
                        }
                }
            }

            if (sharedElements.setIsPushEnabled(isPushEnable)) {
                val pushAnalytics = NotificationAuthorizationAnalytics(applicationContext)
                pushAnalytics.trackPushIsEnabled(isPushEnable)
                Logger.appendTag(TAG_LOGGING).i("update the push status")
            }
            return Result.success()
        }
    }
}