package com.flybits.android.push.models

import android.arch.persistence.room.ColumnInfo
import android.arch.persistence.room.Entity
import android.arch.persistence.room.PrimaryKey
import org.json.JSONObject

/**
 * Stores information for all types of push messages and defines the schema for the ROOM database.
 * Meant for internal use, and not supposed to be presented to client.
 *
 * @param id Unique identifier of the push message received.
 * @param pushRequestId Identifier of the push request associated with this push message. Two push notifications
 * originating from the same request can share this id therefore is not unique.
 * @param timestamp When the push message was generated.
 * @param version Version of push message.
 * @param pushPayloadTypeId Identifier of the push template being received. i.e basic, content, weblink, etc.
 * @param customFields Map containing fields specific to each type of push message.
 * @param event Indicates what has occurred. Null if push message is meant to be displayed.
 * @param title Title of the push message. Null if push message is meant to NOT be displayed,
 * and instead alert that some event has occurred relevant to this user.
 * @param message Body of the push message. Null if push message is meant to NOT be displayed,
 * and instead alert that some event has occurred relevant to this user.
 */
@Entity(tableName = "pushData")
data class PushData(

    @ColumnInfo(name = COLUMN_ID)
    @PrimaryKey
    val id: String,

    @ColumnInfo(name = COLUMN_PUSH_REQUEST_ID)
    val pushRequestId: String?,

    @ColumnInfo(name = COLUMN_TIMESTAMP)
    val timestamp: Long,

    @ColumnInfo(name = COLUMN_VERSION)
    val version: Int,

    @ColumnInfo(name = COLUMN_PUSH_PAYLOAD_TYPE_ID)
    val pushPayloadTypeId: String?,

    @ColumnInfo(name = COLUMN_BODY)
    val body: JSONObject,

    @ColumnInfo(name = COLUMN_TITLE)
    val title: String?,

    @ColumnInfo(name = COLUMN_MESSAGE)
    val message: String?

) {

    companion object {
        const val COLUMN_EVENT = "event"
        const val COLUMN_BODY = "body"
        const val COLUMN_ID = "id"
        const val COLUMN_PUSH_REQUEST_ID = "pushRequestId"
        const val COLUMN_MESSAGE = "message"
        const val COLUMN_TIMESTAMP = "timestamp"
        const val COLUMN_TITLE = "title"
        const val COLUMN_VERSION = "version"
        const val COLUMN_PUSH_PAYLOAD_TYPE_ID = "metadataID"
    }
}