/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.support.annotation.RequiresApi;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.ContextCompat;
import com.flybits.android.push.analytics.PushAnalytics;
import com.flybits.android.push.models.newPush.DisplayablePush;
import com.flybits.commons.library.logging.Logger;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001bB\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B5\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\bH\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/flybits/android/push/FlyNotification;", "", "builder", "Lcom/flybits/android/push/FlyNotification$Builder;", "(Lcom/flybits/android/push/FlyNotification$Builder;)V", "notificationManager", "Landroid/app/NotificationManager;", "id", "", "notification", "Landroid/app/Notification;", "pushAnalytics", "Lcom/flybits/android/push/analytics/PushAnalytics;", "flybitsPushRequestId", "(Landroid/app/NotificationManager;Ljava/lang/String;Landroid/app/Notification;Lcom/flybits/android/push/analytics/PushAnalytics;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getNotification", "()Landroid/app/Notification;", "equals", "", "other", "hashCode", "", "show", "", "toString", "Builder", "push_release"})
public final class FlyNotification {
    private final NotificationManager notificationManager;
    @NotNull
    private final String id;
    @NotNull
    private final Notification notification;
    private final PushAnalytics pushAnalytics;
    private final String flybitsPushRequestId;

    public final void show() {
        this.notificationManager.notify(this.id.hashCode(), this.notification);
        if (this.flybitsPushRequestId != null && this.pushAnalytics != null) {
            PushAnalytics.trackViewed$default(this.pushAnalytics, this.flybitsPushRequestId, 0L, 2, null);
        }
    }

    @NotNull
    public String toString() {
        return "{notificationId: " + this.id + ", flybits push id: " + this.flybitsPushRequestId + ", push analytics: " + (Object)((Object)this.pushAnalytics) + '}';
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof FlyNotification && Intrinsics.areEqual((Object)((FlyNotification)other).flybitsPushRequestId, (Object)this.flybitsPushRequestId) && Intrinsics.areEqual((Object)((FlyNotification)other).id, (Object)this.id) && (((FlyNotification)other).pushAnalytics != null && this.pushAnalytics != null || ((FlyNotification)other).pushAnalytics == null && this.pushAnalytics == null);
    }

    public int hashCode() {
        return Objects.hash(this.flybitsPushRequestId, this.id, this.pushAnalytics == null);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final Notification getNotification() {
        return this.notification;
    }

    public FlyNotification(@NotNull NotificationManager notificationManager, @NotNull String id, @NotNull Notification notification, @Nullable PushAnalytics pushAnalytics, @Nullable String flybitsPushRequestId) {
        Intrinsics.checkParameterIsNotNull((Object)notificationManager, (String)"notificationManager");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
        this.notificationManager = notificationManager;
        this.id = id;
        this.notification = notification;
        this.pushAnalytics = pushAnalytics;
        this.flybitsPushRequestId = flybitsPushRequestId;
    }

    public /* synthetic */ FlyNotification(NotificationManager notificationManager, String string, Notification notification, PushAnalytics pushAnalytics, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        this(notificationManager, string, notification, pushAnalytics, string2);
    }

    public FlyNotification(@NotNull Builder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Object object = builder.getContext().getSystemService("notification");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        NotificationManager notificationManager = (NotificationManager)object;
        String string = builder.getId();
        Notification notification = builder.getNotification().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)notification, (String)"builder.notification.build()");
        this(notificationManager, string, notification, new PushAnalytics(builder.getContext()), builder.getFlybitsPushRequestId());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0000\u0018\u00002\u00020\u0001B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB5\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\rJ\u001f\u0010\u001f\u001a\u00020\u00002\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0!\"\u00020\"\u00a2\u0006\u0002\u0010#J\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\tH\u0002J\u0010\u0010(\u001a\u00020\u00002\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007J\u0018\u0010)\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u001a\u0010)\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\t2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,J\u0010\u0010-\u001a\u00020\u00002\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u0010\u0010.\u001a\u00020\u00002\b\u0010\u001e\u001a\u0004\u0018\u00010\u0007J\u000e\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u000201R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/flybits/android/push/FlyNotification$Builder;", "", "context", "Landroid/content/Context;", "push", "Lcom/flybits/android/push/models/newPush/DisplayablePush;", "channelId", "", "resourceSmallIcon", "", "(Landroid/content/Context;Lcom/flybits/android/push/models/newPush/DisplayablePush;Ljava/lang/String;I)V", "id", "flybitsPushRequestId", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;)V", "body", "getContext", "()Landroid/content/Context;", "displayImageInBigStyle", "", "getFlybitsPushRequestId", "()Ljava/lang/String;", "icon", "Landroid/graphics/Bitmap;", "getId", "notification", "Landroid/support/v4/app/NotificationCompat$Builder;", "getNotification", "()Landroid/support/v4/app/NotificationCompat$Builder;", "style", "Landroid/support/v4/app/NotificationCompat$Style;", "title", "addActions", "actions", "", "Landroid/support/v4/app/NotificationCompat$Action;", "([Landroid/support/v4/app/NotificationCompat$Action;)Lcom/flybits/android/push/FlyNotification$Builder;", "build", "Lcom/flybits/android/push/FlyNotification;", "getBitMap", "resourceIcon", "setBody", "setLargeIcon", "setPendingIntent", "intent", "Landroid/app/PendingIntent;", "setStyle", "setTitle", "setVibration", "vibration", "", "push_release"})
    public static final class Builder {
        private boolean displayImageInBigStyle;
        private Bitmap icon;
        private String title;
        private String body;
        private NotificationCompat.Style style;
        @NotNull
        private final NotificationCompat.Builder notification;
        @NotNull
        private final Context context;
        @NotNull
        private final String id;
        @Nullable
        private final String flybitsPushRequestId;

        @NotNull
        public final NotificationCompat.Builder getNotification() {
            return this.notification;
        }

        @NotNull
        public final Builder setTitle(@Nullable String title) {
            block0: {
                String string = title;
                if (string == null) break block0;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                this.title = title;
                this.notification.setContentTitle((CharSequence)title);
            }
            return this;
        }

        @NotNull
        public final Builder setBody(@Nullable String body) {
            block0: {
                String string = body;
                if (string == null) break block0;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                this.body = body;
                this.notification.setContentText((CharSequence)body);
            }
            return this;
        }

        @NotNull
        public final Builder setStyle(@Nullable NotificationCompat.Style style) {
            block0: {
                NotificationCompat.Style style2 = style;
                if (style2 == null) break block0;
                NotificationCompat.Style style3 = style2;
                boolean bl = false;
                boolean bl2 = false;
                NotificationCompat.Style it = style3;
                boolean bl3 = false;
                this.style = it;
                this.notification.setStyle(it);
            }
            return this;
        }

        @NotNull
        public final Builder addActions(NotificationCompat.Action ... actions) {
            Intrinsics.checkParameterIsNotNull((Object)actions, (String)"actions");
            NotificationCompat.Action[] $this$forEach$iv = actions;
            boolean $i$f$forEach = false;
            NotificationCompat.Action[] actionArray = $this$forEach$iv;
            int n = actionArray.length;
            for (int i = 0; i < n; ++i) {
                NotificationCompat.Action element$iv;
                NotificationCompat.Action it = element$iv = actionArray[i];
                boolean bl = false;
                this.notification.addAction(it);
            }
            return this;
        }

        @NotNull
        public final Builder setLargeIcon(@NotNull Bitmap icon, boolean displayImageInBigStyle) {
            Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
            this.notification.setLargeIcon(icon);
            this.icon = icon;
            this.displayImageInBigStyle = displayImageInBigStyle;
            return this;
        }

        public static /* synthetic */ Builder setLargeIcon$default(Builder builder, Bitmap bitmap, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return builder.setLargeIcon(bitmap, bl);
        }

        @RequiresApi(value=21)
        @NotNull
        public final Builder setLargeIcon(int resourceIcon, boolean displayImageInBigStyle) {
            this.setLargeIcon(this.getBitMap(resourceIcon), displayImageInBigStyle);
            return this;
        }

        public static /* synthetic */ Builder setLargeIcon$default(Builder builder, int n, boolean bl, int n2, Object object) {
            if ((n2 & 2) != 0) {
                bl = true;
            }
            return builder.setLargeIcon(n, bl);
        }

        private final Bitmap getBitMap(int resourceIcon) {
            Bitmap bitmap;
            Drawable drawable = ContextCompat.getDrawable((Context)this.context, (int)resourceIcon);
            if (drawable instanceof BitmapDrawable) {
                Bitmap bitmap2 = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)resourceIcon);
                bitmap = bitmap2;
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"BitmapFactory.decodeReso\u2026rceIcon\n                )");
            } else if (drawable instanceof VectorDrawable || drawable instanceof Drawable) {
                Bitmap bitmap3 = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap3);
                drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                drawable.draw(canvas);
                Bitmap bitmap4 = bitmap3;
                bitmap = bitmap4;
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap4, (String)"bitmap");
            } else {
                throw (Throwable)new IllegalArgumentException("Invalid drawable id, ensure it is correct and that you are passing a BitmapDrawable or VectorDrawable");
            }
            return bitmap;
        }

        @NotNull
        public final Builder setPendingIntent(@NotNull PendingIntent intent) {
            Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
            this.notification.setContentIntent(intent);
            return this;
        }

        @NotNull
        public final Builder setVibration(@NotNull long[] vibration) {
            Intrinsics.checkParameterIsNotNull((Object)vibration, (String)"vibration");
            this.notification.setVibrate(vibration);
            return this;
        }

        @NotNull
        public final FlyNotification build() {
            if (this.style == null) {
                if (this.icon != null && this.displayImageInBigStyle) {
                    NotificationCompat.BigPictureStyle bigPicture = new NotificationCompat.BigPictureStyle();
                    bigPicture.bigPicture(this.icon).bigLargeIcon(null);
                    if (this.title != null) {
                        bigPicture.setBigContentTitle((CharSequence)this.title);
                    }
                    this.notification.setStyle((NotificationCompat.Style)bigPicture);
                } else {
                    NotificationCompat.BigTextStyle bigText = new NotificationCompat.BigTextStyle();
                    if (this.title != null) {
                        bigText.setBigContentTitle((CharSequence)this.title);
                    }
                    if (this.body != null) {
                        bigText.setSummaryText((CharSequence)this.body);
                    }
                    this.notification.setStyle((NotificationCompat.Style)bigText);
                }
            }
            return new FlyNotification(this);
        }

        @NotNull
        public final Context getContext() {
            return this.context;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final String getFlybitsPushRequestId() {
            return this.flybitsPushRequestId;
        }

        @JvmOverloads
        public Builder(@NotNull Context context, @NotNull String id, @NotNull String channelId, @DrawableRes int resourceSmallIcon, @Nullable String flybitsPushRequestId) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)channelId, (String)"channelId");
            this.context = context;
            this.id = id;
            this.flybitsPushRequestId = flybitsPushRequestId;
            NotificationCompat.Builder builder = new NotificationCompat.Builder(this.context, channelId).setSmallIcon(resourceSmallIcon).setAutoCancel(true);
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"NotificationCompat.Build\u2026Icon).setAutoCancel(true)");
            this.notification = builder;
            if (Build.VERSION.SDK_INT >= 26) {
                Object object = this.context.getSystemService("notification");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.app.NotificationManager");
                }
                NotificationManager manager = (NotificationManager)object;
                if (manager.getNotificationChannel(channelId) == null) {
                    Logger.e((String)("The channelId " + channelId + " is not registered with this application. " + "Therefore your notification will not be displayed. " + "Make sure you create a channel with your desired notification channel id and " + "register it with the NotificationManager."));
                }
            }
        }

        public /* synthetic */ Builder(Context context, String string, String string2, int n, String string3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x10) != 0) {
                string3 = null;
            }
            this(context, string, string2, n, string3);
        }

        @JvmOverloads
        public Builder(@NotNull Context context, @NotNull String id, @NotNull String channelId, @DrawableRes int resourceSmallIcon) {
            this(context, id, channelId, resourceSmallIcon, null, 16, null);
        }

        public Builder(@NotNull Context context, @NotNull DisplayablePush push, @NotNull String channelId, @DrawableRes int resourceSmallIcon) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)push, (String)"push");
            Intrinsics.checkParameterIsNotNull((Object)channelId, (String)"channelId");
            this(context, push.getId(), channelId, resourceSmallIcon, push.getParentId());
            this.setTitle(push.getTitle());
            this.setBody(push.getMessage());
        }
    }
}

