package com.flybits.android.push.deserializations;

import android.support.annotation.NonNull;

import com.flybits.android.push.models.PushToken;
import com.flybits.commons.library.deserializations.IDeserializer;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeserializePushToken extends IDeserializer<PushToken> {

    @Override
    public String toJson(@NonNull PushToken obj) {

        if (obj == null){
            return "{}";
        }

        JSONObject jsonObject = new JSONObject();

        try {
            jsonObject.put("deviceToken", obj.getDeviceToken());
            jsonObject.put("network", obj.getType());
            if (obj.getData() != null){
                JSONObject jsonObjectData = new JSONObject(obj.getData());
                jsonObject.put("data", jsonObjectData);
            }
        }catch (JSONException exception){}

        return jsonObject.toString();
    }

    @Override
    public PushToken fromJson(JSONObject jObj) {
        try{
            return new PushToken(jObj.getString("deviceToken"));
        }catch (JSONException exceptions){
            return null;
        }
    }

    @Override
    public PushToken fromJson(JSONArray jsonArray) {
        return null;
    }
}
