/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push.services;

import android.content.Context;
import com.flybits.android.push.deserializations.DeserializePushToken;
import com.flybits.android.push.models.PushToken;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.Result;
import com.google.firebase.messaging.FirebaseMessagingService;

public class FlybitsFirebaseTokenService
extends FirebaseMessagingService {
    private static final String _TAG = "FlybitsFirebaseTokenService";

    public void onNewToken(String refreshedToken) {
        super.onNewToken(refreshedToken);
        Logger.setTag((String)_TAG).i("Refreshed token: " + refreshedToken);
        if (SharedElements.INSTANCE.getSavedJWTToken(this.getApplicationContext()) != null && SharedElements.INSTANCE.getSavedJWTToken(this.getApplicationContext()).length() > 0) {
            this.sendRegistrationToServer(this.getBaseContext(), refreshedToken);
        }
    }

    private Result sendRegistrationToServer(Context context, String token) {
        try {
            PushToken resultSerializationObj = new PushToken(token, null);
            DeserializePushToken deserialization = new DeserializePushToken();
            String json = deserialization.toJson(resultSerializationObj);
            return FlyAway.post((Context)context, (String)"/push/token", (String)json, null, (String)"PushManager.enableFCM", null);
        }
        catch (FlybitsException e) {
            return null;
        }
    }
}

