/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push;

import android.annotation.TargetApi;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.ContextCompat;

public class FlybitsNotificationManager {
    private NotificationChannel notificationChannel;
    private NotificationCompat.Builder notification;
    private Context context;
    private String id;

    private FlybitsNotificationManager(Simplifier builder) {
        if (builder.notification != null) {
            this.notification = builder.notification;
        }
        if (builder.context != null) {
            this.context = builder.context;
        }
        if (builder.id != null) {
            this.id = builder.id;
        }
        if (builder.notificationChannel != null) {
            this.notificationChannel = builder.notificationChannel;
        }
    }

    public NotificationCompat.Builder get() {
        return this.notification;
    }

    public NotificationChannel getChannel() {
        return this.notificationChannel;
    }

    public void show() {
        NotificationManager mNotificationManager = (NotificationManager)this.context.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26 && mNotificationManager != null && this.notificationChannel != null) {
            mNotificationManager.createNotificationChannel(this.notificationChannel);
        }
        if (mNotificationManager != null) {
            int hashOfID = this.id.hashCode();
            mNotificationManager.notify(hashOfID, this.notification.build());
        }
    }

    private static Bitmap getBitmap(Context context, int drawableId) {
        Drawable drawable = ContextCompat.getDrawable((Context)context, (int)drawableId);
        if (drawable instanceof BitmapDrawable) {
            return BitmapFactory.decodeResource((Resources)context.getResources(), (int)drawableId);
        }
        if (drawable instanceof VectorDrawable) {
            return FlybitsNotificationManager.getBitmap((VectorDrawable)drawable);
        }
        return null;
    }

    @TargetApi(value=21)
    private static Bitmap getBitmap(VectorDrawable vectorDrawable) {
        Bitmap bitmap = Bitmap.createBitmap((int)vectorDrawable.getIntrinsicWidth(), (int)vectorDrawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        vectorDrawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        vectorDrawable.draw(canvas);
        return bitmap;
    }

    private static enum NotificationStyle {
        BIG_TEXT,
        BIG_PICTURE;

    }

    public static class Simplifier {
        private NotificationChannel notificationChannel;
        private NotificationCompat.Builder notification;
        private Context context;
        private String id;
        private String channelName;
        private String channelId;
        private int importance;
        private String title;
        private String body;
        private Bitmap bitmap;
        private NotificationStyle style;
        private long[] vibration;
        private int argbLights;

        public Simplifier(@NonNull Context context, @NonNull String id, @Nullable String title, @Nullable String body, int resourceSmallIcon) {
            this.id = id;
            this.context = context;
            this.channelName = "channelFlybitsSDK";
            this.channelId = "channelFlybitsSDK_ID";
            this.title = title;
            this.body = body;
            this.importance = 3;
            this.style = NotificationStyle.BIG_TEXT;
            this.notification = new NotificationCompat.Builder(context, this.channelId).setAutoCancel(true);
            if (title != null) {
                this.notification.setContentTitle((CharSequence)title);
            }
            if (body != null) {
                this.notification.setContentText((CharSequence)body);
            }
            this.notification.setSmallIcon(resourceSmallIcon);
            this.setBadgeIcon(1);
        }

        public Simplifier addActions(NotificationCompat.Action ... actions) {
            if (actions != null && actions.length > 0) {
                for (NotificationCompat.Action action : actions) {
                    this.notification.addAction(action);
                }
            }
            return this;
        }

        public Simplifier setBadgeIcon(int iconType) {
            this.notification.setBadgeIconType(iconType);
            return this;
        }

        public Simplifier setChannel(@NonNull String channelId, @NonNull String channelName, int importance) {
            this.channelName = channelName;
            this.channelId = channelId;
            this.importance = importance;
            if (Build.VERSION.SDK_INT >= 26) {
                this.notification.setChannelId(channelId);
            }
            return this;
        }

        public Simplifier setIcon(Bitmap icon, boolean displayImageInBigStyle) {
            if (icon != null) {
                this.notification.setLargeIcon(icon);
                this.bitmap = icon;
                if (displayImageInBigStyle) {
                    this.style = NotificationStyle.BIG_PICTURE;
                }
            }
            return this;
        }

        public Simplifier setIcon(int resourceIcon, boolean displayImageInBigStyle) {
            Bitmap bitmap = FlybitsNotificationManager.getBitmap(this.context, resourceIcon);
            this.setIcon(bitmap, displayImageInBigStyle);
            return this;
        }

        public Simplifier setLights(@ColorInt int argb, int onMs, int offMs) {
            this.argbLights = argb;
            this.notification.setLights(argb, onMs, offMs);
            return this;
        }

        public Simplifier setPendingIntent(@NonNull PendingIntent intent) {
            this.notification.setContentIntent(intent);
            return this;
        }

        public Simplifier setVibration(long[] vibration) {
            if (vibration != null && vibration.length > 0) {
                this.vibration = vibration;
                this.notification.setVibrate(vibration);
            }
            return this;
        }

        public FlybitsNotificationManager build() {
            if (Build.VERSION.SDK_INT >= 26) {
                this.notificationChannel = new NotificationChannel(this.channelId, (CharSequence)this.channelName, this.importance);
                if (this.vibration != null) {
                    this.notificationChannel.enableVibration(true);
                    this.notificationChannel.setVibrationPattern(this.vibration);
                }
                if (this.argbLights != 0) {
                    this.notificationChannel.enableLights(true);
                    this.notificationChannel.setLightColor(this.argbLights);
                }
            }
            switch (this.style) {
                case BIG_TEXT: {
                    NotificationCompat.BigTextStyle bigText = new NotificationCompat.BigTextStyle();
                    bigText.setBigContentTitle((CharSequence)this.title);
                    bigText.setSummaryText((CharSequence)this.body);
                    this.notification.setStyle((NotificationCompat.Style)bigText);
                    break;
                }
                case BIG_PICTURE: {
                    NotificationCompat.BigPictureStyle bigPicture = new NotificationCompat.BigPictureStyle();
                    bigPicture.bigPicture(this.bitmap).bigLargeIcon(null);
                    bigPicture.setBigContentTitle((CharSequence)this.title);
                    this.notification.setStyle((NotificationCompat.Style)bigPicture);
                }
            }
            return new FlybitsNotificationManager(this);
        }
    }
}

