package com.flybits.android.push.utils;

/**
 * The sort order of the items returned.
 */
public enum SortOrder{

    /**
     * Indicates that the order of sort is in ascending order.
     */
    ASCENDING("asc"),

    /**
     * Indicates that the order of sort is in descending order.
     */
    DESCENDING("desc");

    private final String key;

    /**
     * Constructor that defines the key for each {@code SortOrder} option.
     *
     * @param key the string value representing each {@code SortOrder} option.
     */
    SortOrder(String key) {
        this.key = key;
    }

    /**
     * Get the string representation for the {@code SortOrder} option.
     *
     * @return string representation of the {@code SortOrder} option.
     */
    public String getKey() {
        return this.key;
    }

    /**
     * Get the {@code SortOrder} enum value corresponding to an String representation.
     *
     * @param key the string representation of the {@code SortOrder} enum.
     *
     * @return The {@code SortOrder} enum for the String representation.
     */
    public static SortOrder fromKey(String key) {
        for(SortOrder type : SortOrder.values()) {
            if(type.getKey().equalsIgnoreCase( key)) {
                return type;
            }
        }
        return null;
    }
}