package com.flybits.android.push.deserializations;

import android.content.Context;
import android.support.annotation.NonNull;

import com.flybits.android.push.models.PushTemplate;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.deserializations.IDeserializer;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Iterator;
import java.util.Map;

public class DeserializePushTemplate extends IDeserializer<PushTemplate> {

    private Context context;

    public DeserializePushTemplate(Context context){
        this.context    = context;
    }

    @Override
    public PushTemplate fromJson(JSONObject jObj) {
        try{
            String name     = jObj.getString("name");
            String action   = null, title   = null, message = null;

            JSONArray arrayOfData       = jObj.getJSONArray("body");
            for (int i = 0; i < arrayOfData.length(); i++){

                JSONObject jsonPayload  = arrayOfData.getJSONObject(0);
                if (!jsonPayload.isNull("payload")) {

                    JSONObject jsonMessage  = jsonPayload.getJSONObject("payload");
                    if (!jsonMessage.isNull("title")) {

                        JSONObject jsonAlert = jsonMessage.getJSONObject("title");
                        title = jsonAlert.getString("en");
                    }
                    if (!jsonMessage.isNull("alert")) {

                        JSONObject jsonAlert = jsonMessage.getJSONObject("alert");
                        message = jsonAlert.getString("en");
                    }
                    action = jsonMessage.getString("action");
                }
            }

            PushTemplate.Builder    builder     = new PushTemplate.Builder(context, name, title, message)
                    .setAction(action);

            for (int i = 0; i < arrayOfData.length(); i++){

                JSONObject jsonPayload  = arrayOfData.getJSONObject(0);
                if (!jsonPayload.isNull("payload")) {

                    JSONObject jsonMessage  = jsonPayload.getJSONObject("payload");
                    if (!jsonMessage.isNull("data")) {

                        JSONObject objData = jsonMessage.getJSONObject("data");
                        Iterator<String> keys = objData.keys();
                        while (keys.hasNext()) {
                            String key = keys.next();
                            builder.addCustomField(key, objData.get(key).toString());
                            keys.remove();
                        }
                    }
                }
            }

            if (!jObj.isNull("pushRequestID")){
                builder.setID(jObj.getString("pushRequestID"));
            }

            if (!jObj.isNull("rules")) {
                JSONArray jsonArrayRules = jObj.getJSONArray("rules");
                if (jsonArrayRules.length() > 0) {
                    for (int i = 0; i < jsonArrayRules.length(); i++) {

                        JSONObject object = jsonArrayRules.getJSONObject(i);
                        builder.addRule(object.getString("ruleID"), PushTemplate.ResultType.fromKey(object.getInt("result")));
                    }
                }
            }

            if (!jObj.isNull("Recipients")) {
                JSONArray jsonArrayUsers = jObj.getJSONArray("Recipients");
                if (jsonArrayUsers.length() > 0) {
                    for (int i = 0; i < jsonArrayUsers.length(); i++) {

                        JSONObject object = jsonArrayUsers.getJSONObject(i);
                        builder.addUser(object.getString("userID"), object.getString("deviceID"));
                    }
                }
            }

            if (!jObj.isNull("options")) {
                if (!jObj.isNull("options")) {
                    JSONObject jsonObjectOptions = jObj.getJSONObject("options");
                    builder.setOptions(jsonObjectOptions.getInt("max"), jsonObjectOptions.getInt("delay"), jsonObjectOptions.getInt("cooldown"));
                }
            }
            return builder.build();
        }catch (JSONException exception){}

        return null;
    }

    @Override
    public PushTemplate fromJson(JSONArray jsonArray) {
        return null;
    }

    @Override
    public String toJson(@NonNull PushTemplate obj) {

        if (obj == null ){
            return "{}";
        }
        JSONObject jsonObject   = new JSONObject();
        try{
            jsonObject.put("tenantID", SharedElements.INSTANCE.getProjectID(context));
        }catch(JSONException exception){}

        JSONObject titleObj    = new JSONObject();
        try{
            titleObj.put("en", obj.getTitle());
        }catch(JSONException exception){}

        JSONObject messageObj  = new JSONObject();
        try{
            messageObj.put("en", obj.getMessage());
        }catch(JSONException exception){}

        JSONObject jsonPayload     = new JSONObject();
        try{
            jsonPayload.put("action", obj.getAction());
            jsonPayload.put("title", titleObj);
            jsonPayload.put("alert", messageObj);
            if (obj.getCustomFields().size() > 0){

                JSONObject customFieldsObject   = new JSONObject();
                Iterator itCustom = obj.getCustomFields().entrySet().iterator();
                while (itCustom.hasNext()) {
                    Map.Entry pair = (Map.Entry)itCustom.next();
                    try{
                        customFieldsObject.put((String) pair.getKey(), pair.getValue());
                    }catch(JSONException exception){}
                    itCustom.remove(); 
                }
                jsonPayload.put("data", customFieldsObject);
            }
        }catch(JSONException exception){}

        JSONObject jsonBody     = new JSONObject();
        try{
            jsonBody.put("payload", jsonPayload);
            jsonBody.put("weight", 100);
        }catch(JSONException exception){}

        JSONArray jsonBodyArray = new JSONArray();
        jsonBodyArray.put(jsonBody);

        try {
            jsonObject.put("body", jsonBodyArray);
        }catch (JSONException exception){}

        try{
            jsonObject.put("backgroundPushType", 1);
        }catch(JSONException exception){}
        try{
            jsonObject.put("name", obj.getName());
        }catch(JSONException exception){}
        try{
            jsonObject.put("pushType", 3);
        }catch(JSONException exception){}

        if (obj.getListOfRules().size() > 0) {
            JSONArray arrayRules = new JSONArray();
            Iterator it = obj.getListOfRules().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry pair = (Map.Entry) it.next();

                JSONObject objRules = new JSONObject();
                try {
                    objRules.put("ruleID", (String) pair.getKey());
                    objRules.put("result", pair.getValue());
                } catch (JSONException exception) {}
                arrayRules.put(objRules);

                it.remove();
            }
            try {
                jsonObject.put("rules", arrayRules);
            } catch (JSONException exception) {}
        }

        if (obj.getListOfUsers().size() > 0) {
            JSONArray arrayRecipients = new JSONArray();
            Iterator it2 = obj.getListOfUsers().entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry pair = (Map.Entry) it2.next();

                JSONObject objRules = new JSONObject();
                try {
                    objRules.put("userID", pair.getKey());
                    objRules.put("deviceID", pair.getValue());
                } catch (JSONException exception) {}
                arrayRecipients.put(objRules);

                it2.remove(); 
            }
            try {
                jsonObject.put("Recipients", arrayRecipients);
            } catch (JSONException exception) {}
        }

        if (obj.getOptions() != null) {
            JSONObject jsonOptions = new JSONObject();
            try {
                if (obj.getOptions().getMax() > -1) {
                    jsonOptions.put("max", obj.getOptions().getMax());
                }
            } catch (JSONException exception) {}
            try {
                if (obj.getOptions().getDelay() > -1) {
                    jsonOptions.put("delay", obj.getOptions().getDelay());
                }
            } catch (JSONException exception) {}
            try {
                if (obj.getOptions().getCooldown() > -1) {
                    jsonOptions.put("cooldown", obj.getOptions().getCooldown());
                }
            } catch (JSONException exception) {}
            try {
                jsonOptions.put("sampling", 0);
            } catch (JSONException exception) {}
            try {
                jsonObject.put("options", jsonOptions);
            } catch (JSONException exception) {}
        }
        return jsonObject.toString();
    }


}
