package com.flybits.android.push.deserializations;

import com.flybits.commons.library.deserializations.IDeserializer;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DeserializePushNotificationCustomFields extends IDeserializer<HashMap<String, String>> {

    public DeserializePushNotificationCustomFields() {}

    @Override
    public HashMap<String, String> fromJson(JSONObject jObj) {
        HashMap<String, String> deserializedCustomFields = new HashMap<>();

        try{
            Iterator<String> keys               = jObj.keys();
            while (keys.hasNext()){

                String key                      = keys.next();
                if (key.equals("images")){

                    JSONObject imageObject      = jObj.getJSONObject(key);
                    Iterator<String> imageKeys  = imageObject.keys();

                    while (imageKeys.hasNext()){
                        String imgKey           = imageKeys.next();
                        String imgValue         = imageObject.getString(imgKey);
                        deserializedCustomFields.put(imgKey, imgValue);
                    }
                }else{
                    String value = jObj.getString(key);
                    deserializedCustomFields.put(key, value);
                }
            }
            return deserializedCustomFields;
        }catch (JSONException | NullPointerException exception){}

        return deserializedCustomFields;
    }

    @Override
    public HashMap<String, String> fromJson(JSONArray jsonArray) {
        return new HashMap<>();
    }

    @Override
    public String toJson(HashMap<String, String> obj) {

        if (obj == null || obj.size() == 0){
            return "{}";
        }

        JSONObject jsonObject= new JSONObject();
        Iterator it = obj.entrySet().iterator();
        while (it.hasNext()) {

            Map.Entry pair = (Map.Entry)it.next();
            try {
                jsonObject.put(pair.getKey().toString(), pair.getValue().toString());
            }catch (JSONException e){}

            it.remove();
        }
        return jsonObject.toString();
    }
}
