package com.flybits.android.push.models.pushTypes;

import android.app.PendingIntent;
import android.content.Context;

/**
 * The {@code NotificationMetadata} abstract class allows developers to construct a custom
 * Notification Metadata based on their own Notification Type created through the Developer Portal.
 * Once the Notification Type is created within the Developer Portal, a class that extends this
 * abstract class will be able to parse the JSON representation of your newly created Notification
 * Type. This is important because it will know how to parse the metadata associated to the incoming
 * push notification.
 */
public abstract class NotificationMetadata {

    /**
     * Default Constructor that needs to be implemented in order to define the values for class
     * attributes based on the incoming JSON object.
     *
     * @param json The JSON object that is used to define the attributes of the custom metadata
     *             class that extends this abstract class.
     */
    protected NotificationMetadata(String json) {
        fromJSON(json);
    }

    /**
     * Method that defines how the JSON object should be parsed and associated to the JSON
     * attributes to the class attributes.
     *
     * @param json The JSON object that is used to define the attributes of the custom metadata
     *             class that extends this abstract class.
     */
    public abstract void fromJSON(String json);

    /**
     * Method that defines the {@code PendingIntent} that should be associated to the Notification
     * click.
     *
     * @param context The context of the application.
     *
     * @return The {@code PendingIntent} which is used to define what happens when notification is
     * clicked. If this method returns null it means that nothing should happen.
     */
    public abstract PendingIntent onClick(Context context);
}
