/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins.network;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import com.flybits.commons.library.logging.Logger;
import com.flybits.context.models.ContextData;
import com.flybits.context.plugins.network.NetworkData;
import com.flybits.context.services.FlybitsContextPluginService;

public class NetworkContextPluginService
extends FlybitsContextPluginService {
    private static final String TAG_NETWORK_PLUGIN = "PluginNetwork";

    @Override
    public void initialize(Bundle bundle) {
    }

    @Override
    public String[] getRequiredPermissions() {
        return new String[]{"android.permission.ACCESS_WIFI_STATE", "android.permission.ACCESS_NETWORK_STATE"};
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public ContextData getData() {
        Logger.appendTag((String)TAG_NETWORK_PLUGIN).d("Fetching Data...");
        ConnectivityManager cm = (ConnectivityManager)this.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        return new NetworkData(this.getBaseContext(), activeNetwork);
    }

    @Override
    public void onDestroy() {
        Logger.appendTag((String)TAG_NETWORK_PLUGIN).d("Destroyed");
        super.onDestroy();
    }
}

