/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins.activity;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.flybits.commons.library.logging.Logger;
import com.flybits.context.models.ContextData;
import com.flybits.context.plugins.activity.DeviceRecognitionServiceIntent;
import com.flybits.context.services.FlybitsContextPluginService;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.ActivityRecognition;
import java.util.concurrent.TimeUnit;

public class ActivityContextPluginService
extends FlybitsContextPluginService
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private GoogleApiClient mGoogleApiClient;
    private static final String TAG_ACTIVITY_PLUGIN = "PluginActivity";
    private static final String PERMISSION_ACTIVITY_RECOGNITION = "com.google.android.gms.permission.ACTIVITY_RECOGNITION";

    @Override
    public void initialize(Bundle bundle) {
        if (this.mGoogleApiClient == null) {
            this.mGoogleApiClient = new GoogleApiClient.Builder((Context)this).addApi(ActivityRecognition.API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).build();
        }
    }

    @Override
    public String[] getRequiredPermissions() {
        return new String[]{PERMISSION_ACTIVITY_RECOGNITION};
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public ContextData getData() {
        Logger.appendTag((String)TAG_ACTIVITY_PLUGIN).d("Fetching Data ... ");
        if (this.mGoogleApiClient != null) {
            if (!this.mGoogleApiClient.isConnected()) {
                this.mGoogleApiClient.blockingConnect(10L, TimeUnit.SECONDS);
            }
            if (this.mGoogleApiClient.isConnected()) {
                Intent i = new Intent(this.getBaseContext(), DeviceRecognitionServiceIntent.class);
                PendingIntent mActivityRecongPendingIntent = PendingIntent.getService((Context)this.getBaseContext(), (int)0, (Intent)i, (int)0x40000000);
                ActivityRecognition.ActivityRecognitionApi.requestActivityUpdates(this.mGoogleApiClient, 0L, mActivityRecongPendingIntent);
            }
        }
        return null;
    }

    public void onConnected(@Nullable Bundle bundle) {
        Logger.appendTag((String)TAG_ACTIVITY_PLUGIN).i("GoogleAPIClient: onConnected");
    }

    public void onConnectionSuspended(int i) {
        Logger.appendTag((String)TAG_ACTIVITY_PLUGIN).w("GoogleAPIClient: onConnectionSuspended: " + i);
    }

    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Logger.appendTag((String)TAG_ACTIVITY_PLUGIN).e("GoogleAPIClient: onConnectionFailed: + " + connectionResult);
    }

    @Override
    public void onDestroy() {
        if (this.mGoogleApiClient != null && this.mGoogleApiClient.isConnected()) {
            this.mGoogleApiClient.disconnect();
        }
        Logger.appendTag((String)TAG_ACTIVITY_PLUGIN).d("Destroyed");
        super.onDestroy();
    }
}

