/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.db.dao;

import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityDeletionOrUpdateAdapter;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.arch.persistence.room.SharedSQLiteStatement;
import android.database.Cursor;
import com.flybits.context.db.converters.BeaconTypeConverter;
import com.flybits.context.db.dao.BeaconActiveDAO;
import com.flybits.context.plugins.beacon.BeaconActive;
import com.flybits.context.plugins.beacon.BeaconType;
import java.util.ArrayList;
import java.util.List;

public class BeaconActiveDAO_Impl
implements BeaconActiveDAO {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfBeaconActive;
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfBeaconActive;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfBeaconActive;
    private final SharedSQLiteStatement __preparedStmtOfDeleteBeaconsNotInRange;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public BeaconActiveDAO_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfBeaconActive = new EntityInsertionAdapter<BeaconActive>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `beaconsActive`(`id1`,`id2`,`id3`,`type`,`lastSeen`,`isSent`,`isInRange`,`id`) VALUES (?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, BeaconActive value) {
                if (value.getId1() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId1());
                }
                if (value.getId2() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getId2());
                }
                if (value.getId3() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getId3());
                }
                String _tmp = BeaconTypeConverter.beaconToInteger(value.getType());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                stmt.bindLong(5, value.getLastSeen());
                int _tmp_1 = value.isSent() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp_1);
                int _tmp_2 = value.isInRange() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp_2);
                if (value.getCompositeID() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getCompositeID());
                }
            }
        };
        this.__deletionAdapterOfBeaconActive = new EntityDeletionOrUpdateAdapter<BeaconActive>(__db){

            public String createQuery() {
                return "DELETE FROM `beaconsActive` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, BeaconActive value) {
                if (value.getCompositeID() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCompositeID());
                }
            }
        };
        this.__updateAdapterOfBeaconActive = new EntityDeletionOrUpdateAdapter<BeaconActive>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `beaconsActive` SET `id1` = ?,`id2` = ?,`id3` = ?,`type` = ?,`lastSeen` = ?,`isSent` = ?,`isInRange` = ?,`id` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, BeaconActive value) {
                if (value.getId1() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId1());
                }
                if (value.getId2() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getId2());
                }
                if (value.getId3() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getId3());
                }
                String _tmp = BeaconTypeConverter.beaconToInteger(value.getType());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                stmt.bindLong(5, value.getLastSeen());
                int _tmp_1 = value.isSent() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp_1);
                int _tmp_2 = value.isInRange() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp_2);
                if (value.getCompositeID() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getCompositeID());
                }
                if (value.getCompositeID() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getCompositeID());
                }
            }
        };
        this.__preparedStmtOfDeleteBeaconsNotInRange = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from beaconsActive where isInRange = 0";
                return "DELETE from beaconsActive where isInRange = 0";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM beaconsActive";
                return "DELETE FROM beaconsActive";
            }
        };
    }

    @Override
    public void insert(BeaconActive beacon) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfBeaconActive.insert((Object)beacon);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(BeaconActive beacon) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfBeaconActive.handle((Object)beacon);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(BeaconActive ... beacons) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfBeaconActive.handleMultiple((Object[])beacons);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteBeaconsNotInRange() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteBeaconsNotInRange.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteBeaconsNotInRange.release(_stmt);
        }
    }

    @Override
    public void deleteAll() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BeaconActive> getAll() {
        String _sql = "Select * from beaconsActive";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select * from beaconsActive", (int)0);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfId1 = _cursor.getColumnIndexOrThrow("id1");
            int _cursorIndexOfId2 = _cursor.getColumnIndexOrThrow("id2");
            int _cursorIndexOfId3 = _cursor.getColumnIndexOrThrow("id3");
            int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
            int _cursorIndexOfLastSeen = _cursor.getColumnIndexOrThrow("lastSeen");
            int _cursorIndexOfIsSent = _cursor.getColumnIndexOrThrow("isSent");
            int _cursorIndexOfIsInRange = _cursor.getColumnIndexOrThrow("isInRange");
            int _cursorIndexOfCompositeID = _cursor.getColumnIndexOrThrow("id");
            ArrayList<BeaconActive> _result = new ArrayList<BeaconActive>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                BeaconActive _item = new BeaconActive();
                String _tmpId1 = _cursor.getString(_cursorIndexOfId1);
                _item.setId1(_tmpId1);
                String _tmpId2 = _cursor.getString(_cursorIndexOfId2);
                _item.setId2(_tmpId2);
                String _tmpId3 = _cursor.getString(_cursorIndexOfId3);
                _item.setId3(_tmpId3);
                String _tmp = _cursor.getString(_cursorIndexOfType);
                BeaconType _tmpType = BeaconTypeConverter.fromString(_tmp);
                _item.setType(_tmpType);
                long _tmpLastSeen = _cursor.getLong(_cursorIndexOfLastSeen);
                _item.setLastSeen(_tmpLastSeen);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsSent);
                boolean _tmpIsSent = _tmp_1 != 0;
                _item.setIsSent(_tmpIsSent);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsInRange);
                boolean _tmpIsInRange = _tmp_2 != 0;
                _item.setInRange(_tmpIsInRange);
                String _tmpCompositeID = _cursor.getString(_cursorIndexOfCompositeID);
                _item.setCompositeID(_tmpCompositeID);
                _result.add(_item);
            }
            ArrayList<BeaconActive> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BeaconActive> getAllNotInRange() {
        String _sql = "Select * from beaconsActive where isInRange != 0";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select * from beaconsActive where isInRange != 0", (int)0);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfId1 = _cursor.getColumnIndexOrThrow("id1");
            int _cursorIndexOfId2 = _cursor.getColumnIndexOrThrow("id2");
            int _cursorIndexOfId3 = _cursor.getColumnIndexOrThrow("id3");
            int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
            int _cursorIndexOfLastSeen = _cursor.getColumnIndexOrThrow("lastSeen");
            int _cursorIndexOfIsSent = _cursor.getColumnIndexOrThrow("isSent");
            int _cursorIndexOfIsInRange = _cursor.getColumnIndexOrThrow("isInRange");
            int _cursorIndexOfCompositeID = _cursor.getColumnIndexOrThrow("id");
            ArrayList<BeaconActive> _result = new ArrayList<BeaconActive>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                BeaconActive _item = new BeaconActive();
                String _tmpId1 = _cursor.getString(_cursorIndexOfId1);
                _item.setId1(_tmpId1);
                String _tmpId2 = _cursor.getString(_cursorIndexOfId2);
                _item.setId2(_tmpId2);
                String _tmpId3 = _cursor.getString(_cursorIndexOfId3);
                _item.setId3(_tmpId3);
                String _tmp = _cursor.getString(_cursorIndexOfType);
                BeaconType _tmpType = BeaconTypeConverter.fromString(_tmp);
                _item.setType(_tmpType);
                long _tmpLastSeen = _cursor.getLong(_cursorIndexOfLastSeen);
                _item.setLastSeen(_tmpLastSeen);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsSent);
                boolean _tmpIsSent = _tmp_1 != 0;
                _item.setIsSent(_tmpIsSent);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsInRange);
                boolean _tmpIsInRange = _tmp_2 != 0;
                _item.setInRange(_tmpIsInRange);
                String _tmpCompositeID = _cursor.getString(_cursorIndexOfCompositeID);
                _item.setCompositeID(_tmpCompositeID);
                _result.add(_item);
            }
            ArrayList<BeaconActive> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BeaconActive get(String compositeID) {
        String _sql = "Select * from beaconsActive where id = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select * from beaconsActive where id = ?", (int)1);
        int _argIndex = 1;
        if (compositeID == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, compositeID);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            BeaconActive _result;
            int _cursorIndexOfId1 = _cursor.getColumnIndexOrThrow("id1");
            int _cursorIndexOfId2 = _cursor.getColumnIndexOrThrow("id2");
            int _cursorIndexOfId3 = _cursor.getColumnIndexOrThrow("id3");
            int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
            int _cursorIndexOfLastSeen = _cursor.getColumnIndexOrThrow("lastSeen");
            int _cursorIndexOfIsSent = _cursor.getColumnIndexOrThrow("isSent");
            int _cursorIndexOfIsInRange = _cursor.getColumnIndexOrThrow("isInRange");
            int _cursorIndexOfCompositeID = _cursor.getColumnIndexOrThrow("id");
            if (_cursor.moveToFirst()) {
                _result = new BeaconActive();
                String _tmpId1 = _cursor.getString(_cursorIndexOfId1);
                _result.setId1(_tmpId1);
                String _tmpId2 = _cursor.getString(_cursorIndexOfId2);
                _result.setId2(_tmpId2);
                String _tmpId3 = _cursor.getString(_cursorIndexOfId3);
                _result.setId3(_tmpId3);
                String _tmp = _cursor.getString(_cursorIndexOfType);
                BeaconType _tmpType = BeaconTypeConverter.fromString(_tmp);
                _result.setType(_tmpType);
                long _tmpLastSeen = _cursor.getLong(_cursorIndexOfLastSeen);
                _result.setLastSeen(_tmpLastSeen);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsSent);
                boolean _tmpIsSent = _tmp_1 != 0;
                _result.setIsSent(_tmpIsSent);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsInRange);
                boolean _tmpIsInRange = _tmp_2 != 0;
                _result.setInRange(_tmpIsInRange);
                String _tmpCompositeID = _cursor.getString(_cursorIndexOfCompositeID);
                _result.setCompositeID(_tmpCompositeID);
            } else {
                _result = null;
            }
            BeaconActive beaconActive = _result;
            return beaconActive;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

