package com.flybits.context.plugins

import android.content.Context

/**
 * The [ContextPlugin] interface is responsible for providing the necessary functions needed to
 * create a valid [FlybitsContextPlugin]. A [ContextPlugin] is responsible for retrieving information
 * about a specific entity whether it's a sensor or 3rd party service.
 */
internal interface ContextPlugin {

    /**
     * Start the [ContextPlugin] and initialize all the variables that are needed for the
     * [ContextPlugin] for successfully start collecting data.
     *
     * @param context The application's context.
     */
    fun onStart(context: Context)

    /**
     * The [ContextPlugin] is now being deactivated. Stop the [ContextPlugin] and destroy all the
     * variables that are no longer needed.
     *
     * @param context The application's context.
     */
    fun onStop(context: Context)

    /**
     * If available, refresh the sensor/3rd party data immediately without having to wait for the
     * regular time interval.
     *
     * @param context The application's context.
     */
    fun onRefresh(context: Context)

}
