package com.flybits.context.analytics

import android.content.Context
import com.flybits.commons.library.analytics.Analytics

/**
 * This class is responsible for tracking Location permission analytics. Example of this include:
 * location always allowed, location allowed while app in use, or location never allowed.
 *
 * @param context The context of the application.
 */

class LocationAnalytics(context: Context): Analytics(context) {
    companion object {
        const val analyticsScope = "locationDeviceAnalytics"
    }

    public enum class Action(val actionName: String){
        ALWAYS("always"),
        INUSE("inUse"),
        NEVER("never")
    }

    private fun track(action: Action, value: Boolean = true, timestamp: Long){
        super.track(AnalyticsEvent(analyticsScope, action.actionName, value, timestamp))
    }

    fun trackAlways(timestamp: Long = System.currentTimeMillis()){
        track(Action.ALWAYS, timestamp = timestamp)
    }

    fun trackInUse(timestamp: Long = System.currentTimeMillis()){
        track(Action.INUSE, timestamp = timestamp)
    }

    fun trackNever(timestamp: Long = System.currentTimeMillis()){
        track(Action.NEVER, timestamp = timestamp)
    }
}