package com.flybits.context.plugins.battery;

import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import com.flybits.commons.library.logging.Logger;
import com.flybits.context.models.ContextData;
import com.flybits.context.services.FlybitsContextPluginService;

public class BatteryContextPluginService extends FlybitsContextPluginService {

    private final static String TAG_BATTERY_PLUGIN = "PluginBattery";

    @Override
    public void initialize(Bundle bundle) {}

    @Override
    public String[] getRequiredPermissions() {
        return new String[0];
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public ContextData getData() {
        Logger.appendTag(TAG_BATTERY_PLUGIN).d("Starting... ");
        IntentFilter ifilter    = new IntentFilter(Intent.ACTION_BATTERY_CHANGED);
        return new BatteryData(getBaseContext(), ifilter);
    }

    @Override
    public void onDestroy() {
        Logger.appendTag(TAG_BATTERY_PLUGIN).d("Destroyed");
        super.onDestroy();
    }
}
