/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins.location;

import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import com.flybits.context.models.ContextData;
import org.json.JSONException;
import org.json.JSONObject;

public class LocationData
extends ContextData
implements Parcelable {
    private double lat;
    private double lng;
    private double altitude;
    private float speed;
    private float bearing;
    private int timeZone;
    public static final Parcelable.Creator<LocationData> CREATOR = new Parcelable.Creator<LocationData>(){

        public LocationData createFromParcel(Parcel in) {
            return new LocationData(in);
        }

        public LocationData[] newArray(int size) {
            return new LocationData[size];
        }
    };

    public LocationData() {
    }

    protected LocationData(Parcel in) {
        this.lat = in.readDouble();
        this.lng = in.readDouble();
        this.altitude = in.readDouble();
        this.bearing = in.readFloat();
        this.speed = in.readFloat();
        this.timeZone = in.readInt();
        this.setTime(in.readLong());
    }

    public LocationData(Location location) {
        this.lat = location.getLatitude();
        this.lng = location.getLongitude();
        this.altitude = location.getAltitude();
        this.bearing = location.getBearing();
        this.speed = location.getSpeed();
    }

    public LocationData(String json) {
        this.fromJson(json);
    }

    public double getAltitude() {
        return this.altitude;
    }

    public float getBearing() {
        return this.bearing;
    }

    public double getLatitude() {
        return this.lat;
    }

    public double getLongitude() {
        return this.lng;
    }

    public float getSpeed() {
        return this.speed;
    }

    public int getTimeZone() {
        return this.timeZone;
    }

    @Override
    public String getPluginID() {
        return "ctx.sdk.location";
    }

    @Override
    public String toJson() {
        JSONObject object = new JSONObject();
        try {
            object.put("lat", this.lat);
            object.put("lng", this.lng);
            object.put("altitude", this.altitude);
            object.put("bearing", (double)this.bearing);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return object.toString();
    }

    @Override
    public void fromJson(String json) {
        try {
            JSONObject jsonObj = new JSONObject(json);
            this.lat = jsonObj.getDouble("lat");
            this.lng = jsonObj.getDouble("lng");
            this.altitude = jsonObj.getDouble("altitude");
            this.bearing = (float)jsonObj.getDouble("bearing");
            this.timeZone = jsonObj.getInt("timeZone");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationData that = (LocationData)o;
        if (this.lat != that.lat) {
            return false;
        }
        if (this.lng != that.lng) {
            return false;
        }
        if (this.altitude != that.altitude) {
            return false;
        }
        if (this.bearing != that.bearing) {
            return false;
        }
        return this.timeZone == that.timeZone;
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeDouble(this.lat);
        dest.writeDouble(this.lng);
        dest.writeDouble(this.altitude);
        dest.writeFloat(this.bearing);
        dest.writeFloat(this.speed);
        dest.writeInt(this.timeZone);
        dest.writeLong(this.getTime());
    }
}

