/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins.location;

import android.content.Context;
import android.location.Location;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import androidx.work.WorkerParameters;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.context.models.ContextData;
import com.flybits.context.plugins.location.LocationData;
import com.flybits.context.services.FlybitsContextPluginsWorker;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.concurrent.ExecutionException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u000eH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/flybits/context/plugins/location/LocationContextPluginWorker;", "Lcom/flybits/context/services/FlybitsContextPluginsWorker;", "context", "Landroid/content/Context;", "workerParameters", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "getContext", "()Landroid/content/Context;", "setContext", "(Landroid/content/Context;)V", "fusedLocationClient", "Lcom/google/android/gms/location/FusedLocationProviderClient;", "isGpsEnabled", "", "isNetworkEnabled", "refreshTime", "", "getData", "Lcom/flybits/context/models/ContextData;", "getRequiredPermissions", "", "", "()[Ljava/lang/String;", "initialize", "", "bundle", "Landroid/os/Bundle;", "isSupported", "context_release"})
public final class LocationContextPluginWorker
extends FlybitsContextPluginsWorker {
    private long refreshTime;
    private FusedLocationProviderClient fusedLocationClient;
    private boolean isGpsEnabled;
    private boolean isNetworkEnabled;
    @NotNull
    private Context context;

    @Override
    public void initialize(@Nullable Bundle bundle) {
        this.refreshTime = this.getInputData().getLong("flybits_minimum_refresh_time", 60L);
        FusedLocationProviderClient fusedLocationProviderClient = LocationServices.getFusedLocationProviderClient((Context)this.getApplicationContext());
        Intrinsics.checkExpressionValueIsNotNull((Object)fusedLocationProviderClient, (String)"LocationServices.getFuse\u2026lient(applicationContext)");
        this.fusedLocationClient = fusedLocationProviderClient;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    @NotNull
    public ContextData getData() {
        Logger.setTag((String)"PluginLocation").d("Fetching Location Data ...");
        try {
            Object locationManager = this.context.getSystemService("location");
            if (!(locationManager instanceof LocationManager)) {
                throw (Throwable)new NullPointerException("getSystemService() returns null");
            }
            this.isNetworkEnabled = ((LocationManager)locationManager).isProviderEnabled("network");
            this.isGpsEnabled = Build.VERSION.SDK_INT >= 28 ? ((LocationManager)locationManager).isLocationEnabled() : ((LocationManager)locationManager).isProviderEnabled("gps") || ((LocationManager)locationManager).isProviderEnabled("passive");
            if (this.isGpsEnabled && this.isNetworkEnabled) {
                Location lastLocation;
                FusedLocationProviderClient fusedLocationProviderClient = this.fusedLocationClient;
                if (fusedLocationProviderClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"fusedLocationClient");
                }
                if ((lastLocation = (Location)Tasks.await((Task)fusedLocationProviderClient.getLastLocation())) == null) {
                    throw (Throwable)new FlybitsException("Location Data was not retrieved. Please ensure you have access to Google Play Services on the device.");
                }
                return new LocationData(lastLocation);
            }
            throw (Throwable)new FlybitsException("Location Data was not retrieved. Please ensure both GPS and Network provider are enabled on the device.");
        }
        catch (ExecutionException e) {
            throw (Throwable)new Exception(e.getMessage());
        }
        catch (InterruptedException e) {
            throw (Throwable)new Exception(e.getMessage());
        }
    }

    @Override
    @NotNull
    public String[] getRequiredPermissions() {
        return new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"};
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public final void setContext(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"<set-?>");
        this.context = context;
    }

    public LocationContextPluginWorker(@NotNull Context context, @NotNull WorkerParameters workerParameters) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)workerParameters, (String)"workerParameters");
        super(context, workerParameters);
        this.context = context;
    }
}

