package com.flybits.context.models.results;

import android.content.Context;
import android.os.Handler;

import com.flybits.commons.library.api.results.PagedResult;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.models.internal.QueryParameters;
import com.flybits.context.models.Rule;
import com.flybits.context.utils.RulesQueryParameters;

import java.util.concurrent.ExecutorService;

public class RulesResult extends PagedResult<Rule> {

    public RulesResult(Context context, PagedResultCallback<Rule> callback){
        super(context, callback);
    }

    public RulesResult(Context context, PagedResultCallback<Rule> callback, ExecutorService service){
        super(context, callback, service);
    }

    public RulesResult(Context context, QueryParameters parameters, PagedResultCallback<Rule> callback, ExecutorService service, Handler handler){
        super(context, parameters, callback, service, handler);
    }

    @Override
    public <K extends QueryParameters> RulesResult getMore(Context context, K parameters,
                                                              PagedResultCallback<Rule> callback) {

        return Rule.get(context, (RulesQueryParameters) parameters, callback);
    }
}
