package com.flybits.context.plugins.carrier;

import android.Manifest;
import android.content.Context;
import android.os.Bundle;
import android.telephony.TelephonyManager;

import com.flybits.commons.library.logging.Logger;
import com.flybits.context.models.ContextData;
import com.flybits.context.services.FlybitsContextPluginService;

public class CarrierContextPluginService extends FlybitsContextPluginService {

    private final static String _TAG = "PluginCarrier";

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public ContextData getData() {

        Logger.setTag(_TAG).d("Fetching Data... ");
        TelephonyManager tel = (TelephonyManager) getSystemService(Context.TELEPHONY_SERVICE);
        String simOperator = tel.getSimOperator();
        return new CarrierData(simOperator);
    }

    @Override
    public String[] getRequiredPermissions() {
        return new String[]{Manifest.permission.READ_PHONE_STATE};
    }

    @Override
    public void initialize(Bundle bundle) {
    }

    @Override
    public void onDestroy() {
        Logger.setTag(_TAG).d("...Destroyed");
        super.onDestroy();
    }

}
