package com.flybits.context.plugins.beacon;

/**
 * Indicates the different types of Beacons that are currently supported by Flybits.
 */
public enum BeaconType{

    /**
     * Indicates that the type of Beacon found is an iBeacon.
     */
    IBeacon(1, "iBeacon"),

    /**
     * Indicates that the type of Beacon found is an EddyStone.
     */
    Eddystone(2, "eddystone");

    private final int key;
    private final String value;

    /**
     * Constructor that defines the key for each {@code Category} option.
     *
     * @param key the String value representing each {@code Category} option.
     */
    BeaconType(int key, String value) {
        this.key    = key;
        this.value  = value;
    }

    /**
     * Get the String representation for the {@code Category} option.
     *
     * @return String representation of the {@code Category} option.
     */
    public int getKey() {
        return this.key;
    }

    /**
     * Get the String representation for the {@code Category} option.
     *
     * @return String representation of the {@code Category} option.
     */
    public String getValue() {
        return this.value;
    }

    /**
     * Get the {@code Category} enum value corresponding to an String representation.
     *
     * @param value the String representation of the {@code Category} enum.
     *
     * @return The {@code Category} enum for the String representation.
     */
    public static BeaconType fromValue(String value) {
        for(BeaconType type : BeaconType.values()) {
            if(type.getValue().equalsIgnoreCase(value)) {
                return type;
            }
        }
        return IBeacon;
    }
}