package com.flybits.context.models;

public enum ContextPriority {

    /**
     * Indicates that a context has a Low Priority. This implies that the context's data should sent
     * to the Flybits server only when the user is on WiFi.
     */
    LOW(0),

    /**
     * Indicates that a context has a High Priority. This implies that the context's data should be
     * set to the Flybits Server whenever new data is obtained.
     */
    HIGH(1);

    private final int key;

    /**
     * Constructor that defines the key for each {@code ContextPriority} option.
     *
     * @param key the integer value representing each {@code ContextPriority} option.
     */
    ContextPriority(int key) {
        this.key = key;
    }

    /**
     * Get the integer representation for the {@code ContextPriority} option.
     *
     * @return integer representation of the {@code ContextPriority} option.
     */
    public int getKey() {
        return this.key;
    }

    /**
     * Get the {@code ContextPriority} enum value corresponding to an integer representation.
     *
     * @param key the integer representation of the {@code ContextPriority} enum.
     *
     * @return The {@code ContextPriority} enum for the integer representation.
     */
    public static ContextPriority fromKey(int key) {
        for(ContextPriority type : ContextPriority.values()) {
            if(type.getKey() == key) {
                return type;
            }
        }
        return LOW;
    }
}
