package com.flybits.concierge.utils

import android.content.Context
import android.content.res.TypedArray
import android.support.annotation.StyleRes
import android.support.v4.content.ContextCompat
import com.flybits.concierge.R
import java.util.*

/**
 * Sets the specified style for a specified WebView element.
 * @param rtf ImageView object for loading the image in to.
 * @param context Context of the View.
 * @param styleRes styled attribute information in this Context's theme.
 * @return html string with implied required style.
 */
fun setStreamLineWebViewStyle(rtf: String, context: Context, @StyleRes styleRes: Int): String {
    val attrs = intArrayOf(
        android.R.attr.textColor,
        android.R.attr.textSize
    )
    Arrays.sort(attrs);

    val typedArray: TypedArray =
        context.obtainStyledAttributes(
            styleRes,
            attrs
        )

    val textColor = typedArray.getColor(
        attrs.indexOf(android.R.attr.textColor),
        ContextCompat.getColor(context, R.color.flybits_black)
    )
    val hexTextColor = Integer.toHexString(textColor).substring(2)


    val textSize: Int =
        typedArray.getDimensionPixelSize(
            attrs.indexOf(android.R.attr.textSize),
            context.resources.getDimensionPixelOffset(R.dimen.flybits_streamlined_description_size)
        )

    val htmlData = context.getString(
        R.string.flybits_streamline_webview_style_css,
        hexTextColor,
        textSize,
        rtf
    )

    typedArray.recycle()

    return htmlData
}