package com.flybits.concierge.utils

import android.content.Context
import android.content.Intent
import android.content.res.TypedArray
import android.graphics.Color
import android.support.annotation.StyleRes
import android.support.v4.content.ContextCompat
import android.text.Html
import android.text.SpannableStringBuilder
import android.text.method.LinkMovementMethod
import android.text.style.ClickableSpan
import android.text.style.URLSpan
import android.view.View
import android.widget.TextView
import com.flybits.concierge.R
import com.flybits.concierge.activities.DocumentActivity
import java.util.*


/**
 * Sets the specified style for a specified element.
 * @param context Context of the View.
 * @param styleRes styled attribute information in this Context's theme.
 * @return color with implied required style.
 */
fun setCustomTextColorStyle(context: Context, @StyleRes styleRes: Int): Int {
    val attrs = intArrayOf(
        android.R.attr.textColor
    )
    Arrays.sort(attrs);
    val typedArray: TypedArray? =
        context.obtainStyledAttributes(
            styleRes,
            attrs
        )

    val textColor = typedArray?.getColor(
        attrs.indexOf(android.R.attr.textColor),
        ContextCompat.getColor(context, R.color.flybits_guided_inActive_dotIndicator)
    )
    val hexTextColor = textColor?.let { Integer.toHexString(it).substring(2) }
    typedArray?.recycle()

    return Color.parseColor("#$hexTextColor")
}


data class Span(
    val tncStartIndex: Int,
    val tncEndIndex: Int,
    val privacyPolicyStartIndex: Int,
    val privacyPolicyEndIndex: Int,
    val text: String
)


fun makeLinkClickable(strBuilder: SpannableStringBuilder, span: URLSpan?, context: Context) {
    val start = strBuilder.getSpanStart(span)
    val end = strBuilder.getSpanEnd(span)
    val flags = strBuilder.getSpanFlags(span)
    val clickable: ClickableSpan = object : ClickableSpan() {
        override fun onClick(view: View?) {
            val activityIntent = Intent(context, DocumentActivity::class.java)
            activityIntent.putExtra(
                DocumentActivity.EXTRA_DOCUMENT_TYPE,
                DocumentActivity.DOCUMENT_TYPE_URL
            )
            activityIntent.putExtra(DocumentActivity.EXTRA_DOCUMENT_CLIENT_URL, span?.url)
            context.startActivity(activityIntent)
        }
    }
    strBuilder.setSpan(clickable, start, end, flags)
    strBuilder.removeSpan(span)
}

/**
 * Set links in disclaimer text depending on the number of hrefs in the given text.
 * @param textView a view of TextView to set clickable links.
 * @param html string of type html with probable links.
 * @param context Context object to access resources.
 */
fun setTextViewHTML(textView: TextView, html: String?, context: Context) {
    val sequence: CharSequence =
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.N) {
            Html.fromHtml(html, Html.FROM_HTML_MODE_COMPACT)
        } else {
            Html.fromHtml(html)
        }
    val strBuilder = SpannableStringBuilder(sequence)
    val urls = strBuilder.getSpans(0, sequence.length, URLSpan::class.java)
    for (span in urls) {
        makeLinkClickable(strBuilder, span, context)
    }
    textView.text = strBuilder
    textView.movementMethod = LinkMovementMethod.getInstance()
}