package com.flybits.concierge.guidedoptin.presentation.adapter

import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import com.bumptech.glide.Glide
import com.flybits.concierge.R
import com.flybits.concierge.guidedoptin.presentation.model.ConciergeOptOutItem

/**
 * Adapter responsible for populating opt-out Ui recyclerview
 */
internal class OptOutAdapter(var locationOptInItems: List<ConciergeOptOutItem>) :
    RecyclerView.Adapter<OptOutAdapter.OptOutViewHolder>() {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): OptOutViewHolder {
        return OptOutViewHolder(
            LayoutInflater.from(parent.context)
                .inflate(R.layout.flybits_guided_opt_out_item, parent, false)
        )
    }

    override fun onBindViewHolder(holder: OptOutViewHolder, position: Int) {
        if (locationOptInItems[position].image != 0) {
            Glide.with(holder.image.context).load(locationOptInItems[position].image)
                .into(holder.image)
        } else {
            holder.image.visibility = View.GONE
        }
        holder.body.setText(locationOptInItems[position].body)
    }

    override fun getItemCount(): Int {
        return locationOptInItems.size
    }

    class OptOutViewHolder(view: View) : RecyclerView.ViewHolder(view) {
        var image: ImageView = view.findViewById(R.id.flybits_opt_out_item_image)
        var body: TextView = view.findViewById(R.id.flybits_opt_out_item_text)
    }
}