package com.flybits.concierge.guidedoptin.presentation.adapter

import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import com.bumptech.glide.Glide
import com.flybits.concierge.R
import com.flybits.concierge.guidedoptin.presentation.model.LocationOptInItem

/**
 * Adapter responsible for populating location opt-in Ui recyclerview
 */
internal class LocationOptInAdapter(var locationOptInItems: List<LocationOptInItem>) :
    RecyclerView.Adapter<LocationOptInAdapter.LocationOptInViewHolder>() {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): LocationOptInViewHolder {
        return LocationOptInViewHolder(
            LayoutInflater.from(parent.context)
                .inflate(R.layout.flybits_guided_location_item, parent, false)
        )
    }

    override fun onBindViewHolder(holder: LocationOptInViewHolder, position: Int) {
        if (locationOptInItems[position].image != 0) {
            Glide.with(holder.image.context).load(locationOptInItems[position].image)
                .into(holder.image)
        } else {
            holder.image.visibility = View.GONE
        }
        holder.body.setText(locationOptInItems[position].body)
    }

    override fun getItemCount(): Int {
        return locationOptInItems.size
    }

    class LocationOptInViewHolder(view: View) : RecyclerView.ViewHolder(view) {
        var image: ImageView = view.findViewById(R.id.flybits_guided_location_item_image)
        var body: TextView = view.findViewById(R.id.flybits_guided_location_item_text)
    }

}