package com.flybits.concierge.guidedoptin.data.model.json

import com.flybits.concierge.guidedoptin.*
import com.flybits.concierge.guidedoptin.domain.entity.NotificationsOptInEntity

/**
 * The Notifications model that is a specific implementation of [NotificationsOptInEntity] with Android JSON parser.
 */
internal data class NotificationsOptInModel(
    override val exclude: Boolean = false,
    override val title: String = notificationsTitleDefault,
    override val info: List<NotificationsOptInItemModel> = listOf(
        NotificationsOptInItemModel(
            notificationsImageOneDefault,
            notificationsBodyOneDefault
        ),
        NotificationsOptInItemModel(
            notificationsImageTwoDefault,
            notificationsBodyTwoDefault
        ),
        NotificationsOptInItemModel(
            notificationsImageThreeDefault,
            notificationsBodyThreeDefault
        )
    ),
    override val disclaimerText: String = notificationsDisclaimerTextDefault,
    override val next: String = guidedContinueDefault,
    override val skip: String = guidedSkipDefault
) : NotificationsOptInEntity
