package com.flybits.concierge.views;

import android.app.FragmentManager;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;

import com.flybits.concierge.R;
import com.flybits.concierge.Utils;
import com.wdullaer.materialdatetimepicker.time.TimePickerDialog;

import java.util.Calendar;

public class SurveyTime extends SurveyBaseView implements TimePickerDialog.OnTimeSetListener
{
    private static final String DIALOG_TIME_PICKER = "flybits_con_dialog_time_picker";
    private Button selectButton;
    private Calendar selectedTime;
    private FragmentManager fragmentManager;

    public SurveyTime(Context context, FragmentManager fragmentManager, Calendar calendar)
    {
        super(context);
        this.fragmentManager = fragmentManager;
        selectedTime = calendar;
        init(null, 0);
    }

    public SurveyTime(Context context)
    {
        super(context);
        init(null, 0);
    }

    public SurveyTime(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        init(attrs, 0);
    }

    public SurveyTime(Context context, AttributeSet attrs, int defStyle)
    {
        super(context, attrs, defStyle);
        init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle)
    {
        LayoutInflater inflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View view = inflater.inflate(R.layout.flybits_con_view_survey_time, this, true);

        selectButton = view.findViewById(R.id.flybits_con_view_survey_time_btnTime);
    }

    @Override
    protected void onAttachedToWindow()
    {
        super.onAttachedToWindow();

        if (selectedTime != null)
        {
            selectButton.setText(Utils.getTimeString(selectedTime.getTime()));
        }

        selectButton.setOnClickListener(new OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                Calendar displayedTime = selectedTime != null ? selectedTime : Calendar.getInstance();
                TimePickerDialog dialog = TimePickerDialog.newInstance(
                        SurveyTime.this,
                        displayedTime.get(Calendar.HOUR_OF_DAY),
                        displayedTime.get(Calendar.MINUTE),
                        false
                );

                dialog.show(fragmentManager, DIALOG_TIME_PICKER);
            }
        });
    }

    @Override
    public void onTimeSet(TimePickerDialog view, int hourOfDay, int minute, int second)
    {
        selectedTime = Calendar.getInstance();
        selectedTime.set(Calendar.HOUR_OF_DAY, hourOfDay);
        selectedTime.set(Calendar.MINUTE, minute);

        selectButton.setText(Utils.getTimeString(selectedTime.getTime()));

        callOnClick();
    }

    @Override
    public Object getAnswer()
    {
        return selectedTime;
    }
}
