package com.flybits.concierge.views;

import android.app.FragmentManager;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;

import com.flybits.concierge.R;
import com.flybits.concierge.Utils;
import com.wdullaer.materialdatetimepicker.date.DatePickerDialog;

import java.util.Calendar;

public class SurveyDate extends SurveyBaseView implements DatePickerDialog.OnDateSetListener
{
    private static final String DIALOG_DATE_PICKER = "flybits_con_tag_dialog_date_picker";
    private Button selectButton;
    private Calendar selectedDate;
    private FragmentManager fragmentManager;

    public SurveyDate(Context context, FragmentManager fragmentManager, Calendar calendar)
    {
        super(context);
        this.fragmentManager = fragmentManager;
        selectedDate = calendar;
        init(null, 0);
    }

    public SurveyDate(Context context)
    {
        super(context);
        init(null, 0);
    }

    public SurveyDate(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        init(attrs, 0);
    }

    public SurveyDate(Context context, AttributeSet attrs, int defStyle)
    {
        super(context, attrs, defStyle);
        init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle)
    {
        LayoutInflater inflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View view = inflater.inflate(R.layout.flybits_con_view_survey_date, this, true);

        selectButton = view.findViewById(R.id.flybits_con_view_survey_date_btnDate);
    }

    @Override
    protected void onAttachedToWindow()
    {
        super.onAttachedToWindow();

        if (selectedDate != null)
        {
            selectButton.setText(Utils.getDateString(selectedDate.getTime()));
        }

        selectButton.setOnClickListener(new OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                Calendar displayedDate = selectedDate != null ? selectedDate : Calendar.getInstance();
                DatePickerDialog dialog = DatePickerDialog.newInstance(
                        SurveyDate.this,
                        displayedDate.get(Calendar.YEAR),
                        displayedDate.get(Calendar.MONTH),
                        displayedDate.get(Calendar.DAY_OF_MONTH)
                );

                dialog.show(fragmentManager, DIALOG_DATE_PICKER);

            }
        });
    }

    @Override
    public void onDateSet(DatePickerDialog view, int year, int monthOfYear, int dayOfMonth)
    {
        selectedDate = Calendar.getInstance();
        selectedDate.set(Calendar.YEAR, year);
        selectedDate.set(Calendar.MONTH, monthOfYear);
        selectedDate.set(Calendar.DAY_OF_MONTH, dayOfMonth);

        selectButton.setText(Utils.getDateString(selectedDate.getTime()));

        callOnClick();
    }

    @Override
    public Object getAnswer()
    {
        return selectedDate;
    }
}
