package com.flybits.concierge.viewproviders

import android.view.LayoutInflater
import android.view.ViewGroup
import com.flybits.concierge.ConciergeConstants.EVENT_CONTENT_TYPE
import com.flybits.concierge.FlybitsNavigator
import com.flybits.concierge.FlybitsViewProvider
import com.flybits.concierge.R
import com.flybits.concierge.fragments.EventDetailsFragment
import com.flybits.concierge.models.Events
import com.flybits.concierge.viewholders.EventsViewHolder
import com.flybits.concierge.viewpopulators.EventsViewPopulator

class EventsViewProvider internal constructor(private val eventsViewPopulator: EventsViewPopulator): FlybitsViewProvider<Events> {

    constructor() : this(EventsViewPopulator())

    override fun onCreateViewHolder(parent: ViewGroup): EventsViewHolder {
        return EventsViewHolder(LayoutInflater.from(parent.context)
                .inflate(R.layout.flybits_con_item_template_events, parent, false), eventsViewPopulator)
    }

    override fun getClassType() = Events::class.java

    override fun getContentType() = EVENT_CONTENT_TYPE

    override fun onPushOpened(model: Events, flybitsNavigator: FlybitsNavigator) {
        if (model.events.list.isNotEmpty()){
            flybitsNavigator.openFragment(EventDetailsFragment.newInstance(model.events.list[0]))
        }
    }
}