package com.flybits.concierge.viewmodels

import android.arch.lifecycle.ViewModel
import android.arch.lifecycle.ViewModelProvider
import android.content.Context
import com.flybits.concierge.FlybitsConcierge

class SettingsViewModelFactory(context: Context): ViewModelProvider.Factory {
    private val flybitsConcierge = FlybitsConcierge.with(context.applicationContext)

    override fun <T : ViewModel?> create(modelClass: Class<T>): T {
        return if (modelClass.isAssignableFrom(SettingsViewModel::class.java)){
            SettingsViewModel(flybitsConcierge) as T
        } else {
            throw IllegalArgumentException("ViewModel Not Found")
        }
    }
}