package com.flybits.concierge.viewholders;

import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.R;
import com.flybits.concierge.models.Event;
import com.flybits.concierge.models.Events;
import com.flybits.concierge.viewpopulators.EventsViewPopulator;

public class EventsViewHolder extends FlybitsViewHolder<Events>
{
    private EventsViewPopulator eventsViewPopulator;

    private final LinearLayout thisView;
    private View eventView;
    private ImageView imgHeader;
    private TextView txtTitle;
    private TextView txtLocation;
    private TextView txtDate;

    public EventsViewHolder(View itemView, EventsViewPopulator eventsViewPopulator){
        super(itemView);
        thisView = (LinearLayout) itemView;
        this.eventsViewPopulator = eventsViewPopulator;

    }

    @Override
    public void bindData(Events data, FlybitsNavigator flybitsNavigator)
    {
        thisView.removeAllViews();

        for (Event event : data.events.getList()) {

            eventView = LayoutInflater.from(thisView.getContext()).inflate(R.layout.flybits_con_item_template_event_item, thisView, false);

            imgHeader = eventView.findViewById(R.id.flybits_con_events_item_imgHeader);
            txtTitle = eventView.findViewById(R.id.flybits_con_events_item_txtTitle);
            txtLocation = eventView.findViewById(R.id.flybits_con_events_item_txtLocation);
            txtDate = eventView.findViewById(R.id.flybits_con_events_item_txtDate);

            eventsViewPopulator.populate(event, flybitsNavigator, txtTitle, txtLocation, txtDate, imgHeader, eventView);

            thisView.addView(eventView);

        }

    }
}
