package com.flybits.concierge.models

import android.os.Parcel
import android.os.Parcelable.Creator
import com.flybits.android.kernel.models.LocalizedValue

/**
 * The {@link SimpleCard} class is used to define all the necessary parameters associated to
 * SimpleCard content template (Streamlined Content template type 1)
 */
class SimpleCard : BaseTemplate {

    var title: LocalizedValue? = null
    var header: LocalizedValue? = null
    var description: LocalizedValue? = null
    var image: LocalizedValue? = null
    var link: CardLink? = null
    var details: Details? = null

    constructor() : super()

    constructor(parcel: Parcel) : super(parcel) {
        title = parcel.readParcelable(LocalizedValue::class.java.classLoader)
        header = parcel.readParcelable(LocalizedValue::class.java.classLoader)
        description = parcel.readParcelable(LocalizedValue::class.java.classLoader)
        image = parcel.readParcelable(LocalizedValue::class.java.classLoader)
        link = parcel.readParcelable(CardLink::class.java.classLoader)
        details = parcel.readParcelable(Details::class.java.classLoader)
    }

    override fun writeToParcel(dest: Parcel?, flags: Int) {
        super.writeToParcel(dest, flags)
        dest?.let {
            it.writeParcelable(title, flags)
            it.writeParcelable(header, flags)
            it.writeParcelable(description, flags)
            it.writeParcelable(image, flags)
            it.writeParcelable(link, flags)
            it.writeParcelable(details, flags)
        }
    }

    override fun describeContents(): Int = 0

    companion object {
        @JvmField
        val CREATOR: Creator<SimpleCard> =
            object : Creator<SimpleCard> {
                override fun createFromParcel(`in`: Parcel): SimpleCard? {
                    return SimpleCard(`in`)
                }

                override fun newArray(size: Int): Array<SimpleCard?> {
                    return arrayOfNulls(size)
                }
            }
    }

}