package com.flybits.concierge.models;

import android.os.Parcel;

import com.flybits.android.kernel.models.LocalizedValue;

public class Article extends BaseTemplate
{
    public LocalizedValue title;
    public LocalizedValue description;
    public String imageURL;
    public String sourceName;
    public String url;

    public Article()
    {
    }

    protected Article(Parcel in)
    {
        super(in);
        title = in.readParcelable(LocalizedValue.class.getClassLoader());
        description = in.readParcelable(LocalizedValue.class.getClassLoader());
        imageURL = in.readString();
        sourceName = in.readString();
        url = in.readString();
    }

    @Override
    public int describeContents()
    {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags)
    {
        super.writeToParcel(dest, flags);
        dest.writeParcelable(title, flags);
        dest.writeParcelable(description, flags);
        dest.writeString(imageURL);
        dest.writeString(sourceName);
        dest.writeString(url);
    }

    public static final Creator<Article> CREATOR = new Creator<Article>()
    {
        @Override
        public Article createFromParcel(Parcel in)
        {
            return new Article(in);
        }

        @Override
        public Article[] newArray(int size)
        {
            return new Article[size];
        }
    };
}
