package com.flybits.concierge.activities

import android.content.Intent
import android.os.Bundle
import android.support.v4.app.Fragment
import com.flybits.concierge.R
import com.flybits.concierge.fragments.SimpleCardDetailFragment
import kotlinx.android.synthetic.main.flybits_streamline_simplecard_activity.*

class SimpleCardDetailActivity : SingleFragmentActivity() {

    companion object {
        const val EXTRA_SIMPLECARD_DETAILS = "flybits_con_extra_simplecard_details"
        const val EXTRA_USER_ACTION_HANDLER = "flybits_con_extra_user_action_handler"
    }

    override fun onCreateSingleContentActivity(intent: Intent): Fragment {
        return SimpleCardDetailFragment.newInstance(
            intent.getParcelableExtra(EXTRA_SIMPLECARD_DETAILS)
            , intent.getParcelableExtra(EXTRA_USER_ACTION_HANDLER)
        )
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        setContentView(R.layout.flybits_streamline_simplecard_activity)

        // add custom back button
        setSupportActionBar(toolbar)
        supportActionBar?.setDisplayHomeAsUpEnabled(true);
        supportActionBar?.setDisplayShowHomeEnabled(true);
    }
}
