package com.flybits.concierge.viewholders;

import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.R;
import com.flybits.concierge.models.Link;
import com.flybits.concierge.models.Links;
import com.flybits.concierge.viewpopulators.LinksViewPopulator;

public class LinksViewHolder extends FlybitsViewHolder<Links>
{
    private LinearLayout thisView;
    private LinksViewPopulator linksViewPopulator;
    private View linkView;
    private TextView linkHeading;
    private TextView linkBody;
    private View linkViewRule;

    public LinksViewHolder(View view, LinksViewPopulator linksViewPopulator)
    {
        super(view);
        this.thisView = (LinearLayout) view;
        this.linksViewPopulator = linksViewPopulator;
    }

    @Override
    public void bindData(Links data, FlybitsNavigator flybitsNavigator)
    {

        thisView.removeAllViews();

        boolean isLinkAdded = false;

        for (Link link : data.links.getList()) {

            linkView = LayoutInflater.from(thisView.getContext()).inflate(R.layout.flybits_con_item_template_link, thisView, false);

            linkHeading = linkView.findViewById(R.id.flybits_con_item_template_link_txtTitle);
            linkBody = linkView.findViewById(R.id.flybits_con_item_template_link_txtBody);
            linkViewRule = linkView.findViewById(R.id.flybits_con_item_template_link_viewRule);

            if(!isLinkAdded) {
                linkViewRule.setVisibility(View.VISIBLE);
                isLinkAdded = true;
            } else {
                linkViewRule.setVisibility(View.GONE);
            }

            linksViewPopulator.populate(link, data.getContent().getId(), linkHeading, linkBody, linkView);
            thisView.addView(linkView);

        }

    }

}
