package com.flybits.concierge.models;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;

import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.concierge.activities.YouTubePlayerActivity;

public class Video extends BaseTemplate {

    public Video()
    {
    }

    public LocalizedValue title;
    public String url;
    public String duration;
    public String imageURL;

    protected Video(Parcel in)
    {
        super(in);
        title = in.readParcelable(LocalizedValue.class.getClassLoader());
        url = in.readString();
        duration = in.readString();
        imageURL = in.readString();
    }

    public static final Creator<Video> CREATOR = new Creator<Video>()
    {
        @Override
        public Video createFromParcel(Parcel in)
        {
            return new Video(in);
        }

        @Override
        public Video[] newArray(int size)
        {
            return new Video[size];
        }
    };

    @Override
    public int describeContents()
    {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags)
    {
        super.writeToParcel(dest,flags);
        dest.writeParcelable(title, flags);
        dest.writeString(url);
        dest.writeString(duration);
        dest.writeString(imageURL);
    }

    public void watchYoutubeVideo(Context context, String id)
    {
        Intent intent = new Intent(context, YouTubePlayerActivity.class);
        intent.putExtra(YouTubePlayerActivity.ARG_ID_KEY, id);
        context.startActivity(intent);
    }
}
