package com.flybits.concierge.activities

import android.content.Intent
import android.support.v4.app.Fragment
import android.webkit.WebView
import com.flybits.commons.library.exceptions.FlybitsException
import com.flybits.commons.library.logging.Logger
import com.flybits.concierge.FlybitsConcierge
import com.flybits.concierge.R
import com.flybits.concierge.fragments.DocumentFragment

/**
 * This activity is responsible for displaying either the Terms of Service or Privacy Policy.
 */
class DocumentActivity: SingleFragmentActivity() {

    companion object {
        const val EXTRA_DOCUMENT_TYPE = "flybits_con_extra_document_type"
        const val DOCUMENT_TYPE_PRIVACY_POLICY = "flybits_con_document_type_privacy_policy"
        const val DOCUMENT_TYPE_TOS= "flybits_con_document_type_terms_of_service"
        const val DOCUMENT_TYPE_URL= "flybits_con_document_type_url"
        const val EXTRA_DOCUMENT_CLIENT_URL= "flybits_con_document_client_url"
    }

    override fun onCreateSingleContentActivity(intent: Intent): Fragment {
        val type: String = intent.extras?.getString(EXTRA_DOCUMENT_TYPE, DOCUMENT_TYPE_PRIVACY_POLICY) ?: ""
        return when (type){
            DOCUMENT_TYPE_PRIVACY_POLICY -> {
                supportActionBar?.title = resources.getString(R.string.flybits_con_settings_privacy_policy)
                val url = FlybitsConcierge.with(this).configuration.privacyPolicyUrl
                val text = FlybitsConcierge.with(this).configuration.privacyPolicyText
                DocumentFragment.newInstance(url,text)
            }
            DOCUMENT_TYPE_TOS -> {
                supportActionBar?.title = resources.getString(R.string.flybits_con_settings_terms_of_service)
                val url = FlybitsConcierge.with(this).configuration.tncUrl
                val text = FlybitsConcierge.with(this).configuration.tncText
                DocumentFragment.newInstance(url,text)
            }
            DOCUMENT_TYPE_URL -> {
                supportActionBar?.title = ""
                val url: String = intent.extras?.getString(EXTRA_DOCUMENT_CLIENT_URL) ?: ""
                val text = null
                DocumentFragment.newInstance(url,text)
            }
            else -> {
                val e = FlybitsException("Invalid document type found")
                Logger.exception("DocumentActivity.onCreateSingleContentActivity", e)
                throw e
            }
        }
    }

    override fun onBackPressed() {
        val webview = findViewById<WebView>(R.id.flybits_con_fragment_document_webBody)
        if(webview != null && webview.canGoBack()){
            webview.goBack()
        }
        else{
            super.onBackPressed()
        }
    }
}