package com.flybits.concierge

import android.os.Parcelable
import com.flybits.concierge.models.BaseTemplate

/**
 * Responsible for handling user actions in the UI and responding accordingly.
 */
interface UserActionHandler<T: BaseTemplate>: Parcelable {

    /**
     * Implementation should handle user action that has occurred.
     *
     * @param action Action that has occurred.
     * @param data Data associated with the tile for which the action has occurred.
     * @param flybitsNavigator [FlybitsNavigator] for navigating and displaying elements in the UI.
     *
     */
    fun onUserAction(action: Int, data: T, flybitsNavigator: FlybitsNavigator)
}