package com.flybits.concierge

/**
 * Callback is used for the 2 phase Opt in Flow.
 **/
interface OptIn2PhaseCallback {

    /**
     * This is called as callback for the 2 Phase Opt In, implemented by the client
     * on [FlybitsConcierge.conciergeFragment]
     *
     * @param optInStatus Indicates the client when the user successfully Opts In.
     * @param conciergeConnectCallback This indicates the [FlybitsConcierge] the client has called the
     * [ConciergeConnectCallBack.connect] to authenticate the User
     */
    fun onOptIn2PhaseCallback(
        optInStatus: Boolean,
        conciergeConnectCallback: ConciergeConnectCallBack
    )
}