/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.views;

import android.app.FragmentManager;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import com.flybits.concierge.R;
import com.flybits.concierge.Utils;
import com.flybits.concierge.views.SurveyBaseView;
import com.wdullaer.materialdatetimepicker.date.DatePickerDialog;
import java.util.Calendar;

public class SurveyDate
extends SurveyBaseView
implements DatePickerDialog.OnDateSetListener {
    private static final String DIALOG_DATE_PICKER = "flybits_con_tag_dialog_date_picker";
    private Button selectButton;
    private Calendar selectedDate;
    private FragmentManager fragmentManager;

    public SurveyDate(Context context, FragmentManager fragmentManager, Calendar calendar) {
        super(context);
        this.fragmentManager = fragmentManager;
        this.selectedDate = calendar;
        this.init(null, 0);
    }

    public SurveyDate(Context context) {
        super(context);
        this.init(null, 0);
    }

    public SurveyDate(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public SurveyDate(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle) {
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.flybits_con_view_survey_date, (ViewGroup)this, true);
        this.selectButton = (Button)view.findViewById(R.id.flybits_con_view_survey_date_btnDate);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.selectedDate != null) {
            this.selectButton.setText((CharSequence)Utils.getDateString(this.selectedDate.getTime()));
        }
        this.selectButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Calendar displayedDate = SurveyDate.this.selectedDate != null ? SurveyDate.this.selectedDate : Calendar.getInstance();
                DatePickerDialog dialog = DatePickerDialog.newInstance((DatePickerDialog.OnDateSetListener)SurveyDate.this, (int)displayedDate.get(1), (int)displayedDate.get(2), (int)displayedDate.get(5));
                dialog.show(SurveyDate.this.fragmentManager, SurveyDate.DIALOG_DATE_PICKER);
            }
        });
    }

    public void onDateSet(DatePickerDialog view, int year, int monthOfYear, int dayOfMonth) {
        this.selectedDate = Calendar.getInstance();
        this.selectedDate.set(1, year);
        this.selectedDate.set(2, monthOfYear);
        this.selectedDate.set(5, dayOfMonth);
        this.selectButton.setText((CharSequence)Utils.getDateString(this.selectedDate.getTime()));
        this.callOnClick();
    }

    @Override
    public Object getAnswer() {
        return this.selectedDate;
    }
}

