/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import com.flybits.android.kernel.reservedtemplates.survey.models.QuestionChoice;
import com.flybits.concierge.R;
import com.flybits.concierge.views.SurveyBaseView;
import java.util.ArrayList;
import java.util.List;

public class SurveyMultipleChoice
extends SurveyBaseView {
    private int choice;
    private List<QuestionChoice> choices;
    private List<RadioButton> radios;

    public SurveyMultipleChoice(Context context, List<QuestionChoice> choices, int choice) {
        super(context);
        this.choices = choices;
        this.choice = choice;
        this.init(null, 0);
    }

    public SurveyMultipleChoice(Context context) {
        super(context);
        this.init(null, 0);
    }

    public SurveyMultipleChoice(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public SurveyMultipleChoice(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle) {
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.flybits_con_view_survey_multiple_choice, (ViewGroup)this, true);
        RadioGroup radioGroup = (RadioGroup)view.findViewById(R.id.flybits_con_view_survey_multiple_choice_lytRadioGroup);
        this.radios = new ArrayList<RadioButton>();
        CompoundButton.OnCheckedChangeListener checkChangedListener = new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                for (RadioButton btn : SurveyMultipleChoice.this.radios) {
                    btn.setChecked(false);
                }
                if (isChecked) {
                    buttonView.setChecked(true);
                }
                SurveyMultipleChoice.this.callOnClick();
            }
        };
        for (int i = 0; i < this.choices.size(); ++i) {
            QuestionChoice choice = this.choices.get(i);
            RadioButton button = (RadioButton)inflater.inflate(R.layout.flybits_con_view_survey_radio, (ViewGroup)radioGroup, false);
            this.radios.add(button);
            button.setOnCheckedChangeListener(checkChangedListener);
            button.setText((CharSequence)choice.value.getValue());
            button.setId(i + 100);
            radioGroup.addView((View)button);
            button.setChecked(i == this.choice);
        }
    }

    @Override
    public Object getAnswer() {
        for (int i = 0; i < this.radios.size(); ++i) {
            if (!this.radios.get(i).isChecked()) continue;
            return i;
        }
        return null;
    }
}

