package com.flybits.concierge.views;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import android.widget.TextView;

import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.R;
import com.flybits.concierge.adapters.PlaceAutocompleteAdapter;
import com.google.android.gms.location.places.AutocompletePrediction;
import com.google.android.gms.location.places.GeoDataClient;
import com.google.android.gms.location.places.Places;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;

import org.json.JSONException;
import org.json.JSONObject;

public class SurveyLocation extends SurveyBaseView
{
    private static final LatLngBounds LAT_LNG_BOUNDS = new LatLngBounds(new LatLng(-40, -168), new LatLng(70, 136));

    private static final String KEY_ID = "id";
    private static final String KEY_NAME = "name";

    private AutoCompleteTextView autoTextView;
    private PlaceAutocompleteAdapter autocompleteAdapter;
    private JSONObject jsonObject;
    private TextView headerTextView;
    private TextView locationTextView;
    private TextView noApiTextView;

    public SurveyLocation(Context context, String json)
    {
        super(context);

        if (!TextUtils.isEmpty(json))
        {
            try
            {
                jsonObject = new JSONObject(json);
            }
            catch (JSONException e)
            {
                Logger.exception(SurveyLocation.class.getSimpleName(), e);
            }
        }

        init(null, 0);
    }

    public SurveyLocation(Context context)
    {
        super(context);
        init(null, 0);
    }

    public SurveyLocation(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        init(attrs, 0);
    }

    public SurveyLocation(Context context, AttributeSet attrs, int defStyle)
    {
        super(context, attrs, defStyle);
        init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle)
    {
        LayoutInflater inflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View view = inflater.inflate(R.layout.flybits_con_view_survey_location, this, true);

        noApiTextView = view.findViewById(R.id.flybits_con_view_survey_location_no_key);
        autoTextView = view.findViewById(R.id.flybits_con_view_survey_location_autocomplete_txtView);
        headerTextView = view.findViewById(R.id.flybits_con_view_survey_location_header);
        locationTextView = view.findViewById(R.id.flybits_con_view_survey_location_text);

        GeoDataClient geoDataClient = Places.getGeoDataClient(getContext());
        autocompleteAdapter = new PlaceAutocompleteAdapter(getContext(), geoDataClient, LAT_LNG_BOUNDS, null);
        autoTextView.setAdapter(autocompleteAdapter);
        autoTextView.setOnItemClickListener(itemClickListener);

        try
        {
            ApplicationInfo ai = getContext().getPackageManager()
                    .getApplicationInfo(getContext().getPackageName(), PackageManager.GET_META_DATA);
            Bundle bundle = ai.metaData;
            String googleApiKey = bundle.getString("com.google.android.geo.API_KEY");

            if (TextUtils.isEmpty(googleApiKey))
            {
                noGoogleKey();
            }
        }
        catch (Exception e)
        {
            noGoogleKey();
        }
    }

    @Override
    protected void onAttachedToWindow()
    {
        super.onAttachedToWindow();

        setLocationText();
        if (jsonObject != null)
        {
            try
            {
                autoTextView.setText(jsonObject.getString(KEY_NAME));
            }
            catch (JSONException e)
            {
                Logger.exception(SurveyLocation.class.getSimpleName(), e);
            }
        }
    }

    private void setLocationText()
    {
        headerTextView.setVisibility(GONE);
        locationTextView.setVisibility(GONE);

        if (jsonObject != null)
        {
            headerTextView.setVisibility(VISIBLE);
            locationTextView.setVisibility(VISIBLE);

            try
            {
                locationTextView.setText(jsonObject.getString(KEY_NAME));
            }
            catch (JSONException e)
            {
                locationTextView.setText("--");
                Logger.exception(SurveyLocation.class.getSimpleName(), e);
            }
        }
    }

    private void noGoogleKey()
    {
        autoTextView.setVisibility(GONE);
        noApiTextView.setVisibility(VISIBLE);
    }

    @Override
    public Object getAnswer()
    {
        return jsonObject != null ? jsonObject.toString() : null;
    }

    private AdapterView.OnItemClickListener itemClickListener = new AdapterView.OnItemClickListener()
    {
        @Override
        public void onItemClick(AdapterView<?> parent, View view, int position, long id)
        {
            AutocompletePrediction item = autocompleteAdapter.getItem(position);
            CharSequence locationName = item.getFullText(null);
            CharSequence locationId = item.getPlaceId();

            try
            {
                jsonObject = new JSONObject();
                jsonObject.put(KEY_ID, locationId);
                jsonObject.put(KEY_NAME, locationName);
            }
            catch (JSONException e)
            {
                jsonObject = null;
                Logger.exception(SurveyLocation.class.getSimpleName(), e);
            }

            setLocationText();
            callOnClick();
        }
    };
}
