package com.flybits.concierge;

import android.support.annotation.Nullable;

import com.flybits.concierge.exception.ConciergeUninitializedException;

import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * Responsible for retrieving {@Link FlybitsViewProvider}'s that have been registered
 * in the {@link FlybitsConcierge}.
 */
public interface FlybitsViewProviderGetter {

    /**
     * Get list of registered {@link FlybitsViewProvider}s.
     *
     * @return List of registered {@link FlybitsViewProvider}s.
     */
    @Nullable
    Collection<FlybitsViewProvider> getFlybitsViewProviders() throws ConciergeUninitializedException;

    /**
     * Retrieve {@link FlybitsViewProvider} for a specific content-type.
     *
     * @param contentType Content-type of the {@link FlybitsViewProvider} to be retrieved.
     * @return Retrieved FlybitsViewProvider, null if content-type was not registered.
     */
    @Nullable
    FlybitsViewProvider getFlybitsViewProvider(String contentType) throws ConciergeUninitializedException;


    /**
     * Retrieve list of supported content types
     *
     * @return list of content types for which a {@link FlybitsViewProvider} is registered
     */
    Set<String> getViewProviderSupportedContentTypes() throws ConciergeUninitializedException;
}
