/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.views;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;
import com.flybits.android.kernel.reservedtemplates.survey.models.QuestionChoice;
import com.flybits.concierge.R;
import com.flybits.concierge.views.SurveyBaseView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SurveyDropDown
extends SurveyBaseView {
    private int choice;
    private List<QuestionChoice> choices;
    private Button selectButton;
    private List<String> items;

    public SurveyDropDown(Context context, List<QuestionChoice> choices, int choice) {
        super(context);
        this.choices = choices;
        this.choice = choice;
        this.init(null, 0);
    }

    public SurveyDropDown(Context context) {
        super(context);
        this.init(null, 0);
    }

    public SurveyDropDown(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public SurveyDropDown(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle) {
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.flybits_con_view_survey_drop_down, (ViewGroup)this, true);
        this.items = new ArrayList<String>(this.choices.size());
        for (QuestionChoice choice : this.choices) {
            this.items.add(choice.value.getValue());
        }
        this.selectButton = (Button)view.findViewById(R.id.flybits_con_view_survey_drop_down_btnOptions);
    }

    protected void onAttachedToWindow() {
        String text;
        super.onAttachedToWindow();
        String string2 = text = this.choice >= 0 ? this.items.get(this.choice) : null;
        if (text != null) {
            this.selectButton.setText((CharSequence)text);
        }
        this.selectButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                new MaterialDialog.Builder(SurveyDropDown.this.getContext()).title((CharSequence)"Options").items((Collection)SurveyDropDown.this.items).itemsCallback(new MaterialDialog.ListCallback(){

                    public void onSelection(MaterialDialog dialog, View view, int which, CharSequence text) {
                        SurveyDropDown.this.selectButton.setText((CharSequence)SurveyDropDown.this.items.get(which));
                        SurveyDropDown.this.choice = which;
                        SurveyDropDown.this.callOnClick();
                    }
                }).negativeText(0x1040000).positiveText((CharSequence)"clear").onPositive(new MaterialDialog.SingleButtonCallback(){

                    public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                        SurveyDropDown.this.selectButton.setText(R.string.flybits_con_view_survey_drop_down_select);
                        SurveyDropDown.this.callOnClick();
                    }
                }).show();
            }
        });
    }

    @Override
    public Object getAnswer() {
        if (this.choice < 0) {
            return null;
        }
        return this.choice;
    }
}

