/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge;

import android.content.Context;
import android.content.SharedPreferences;

public class InternalPreferences {
    protected static final String PREFS_NAME = "ConciergePrefs";
    protected static final String TNC_ACCEPTED = "tnc_accepted";
    protected static final String FB_PUSH_TOKEN = "fire_base_push_token";
    protected static final String ONBOARDING_DONE = "onboarded";
    protected static final String SURVEY_DONE = "survey_done";
    protected static final String AUTO_AUTH_ON_CONNECT = "auto_authenticate";
    protected static final String IS_OPTED_OUT = "ctn_flybits_opted_out";

    private static SharedPreferences getInstance(Context context) {
        return context.getSharedPreferences(PREFS_NAME, 0);
    }

    public static void saveTNCAccepted(Context currentContext, boolean value) {
        currentContext.getSharedPreferences(PREFS_NAME, 0).edit().putBoolean(TNC_ACCEPTED, value).apply();
    }

    private static SharedPreferences.Editor getSaveInstance(Context context) {
        return InternalPreferences.getInstance(context).edit();
    }

    public static boolean isTNCAccepted(Context context) {
        return InternalPreferences.getInstance(context).getBoolean(TNC_ACCEPTED, false);
    }

    public static void setAutoRetryAuthOnConnected(Context currentContext, boolean value) {
        InternalPreferences.getSaveInstance(currentContext).putBoolean(AUTO_AUTH_ON_CONNECT, value).apply();
    }

    public static boolean isAutoRetryAuthOnConnectedEnabled(Context currentContext) {
        return InternalPreferences.getInstance(currentContext).getBoolean(AUTO_AUTH_ON_CONNECT, true);
    }

    public static boolean isOnBoardingDone(Context context) {
        return InternalPreferences.getInstance(context).getBoolean(ONBOARDING_DONE, false);
    }

    public static void saveOnBoardingDone(Context currentContext, boolean value) {
        InternalPreferences.getSaveInstance(currentContext).putBoolean(ONBOARDING_DONE, value).apply();
    }

    public static void savePushToken(Context currentContext, String value) {
        InternalPreferences.getSaveInstance(currentContext).putString(FB_PUSH_TOKEN, value).apply();
    }

    public static String pushToken(Context currentContext) {
        return InternalPreferences.getInstance(currentContext).getString(FB_PUSH_TOKEN, null);
    }

    public static boolean isSurveyDone(Context currentContext) {
        return InternalPreferences.getInstance(currentContext).getBoolean(SURVEY_DONE, false);
    }

    public static void saveSurveyDone(Context currentContext, boolean value) {
        InternalPreferences.getSaveInstance(currentContext).putBoolean(SURVEY_DONE, value).apply();
    }
}

