/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.fragments;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.FlybitsConcierge;
import com.flybits.concierge.R;

public class PrivacyPolicyFragment
extends Fragment {
    private WebView webView;
    private View loadingView;
    private View errorView;
    private Button errorRetryButton;
    private boolean errorPresent = false;
    private String url;

    public static PrivacyPolicyFragment newInstance() {
        return new PrivacyPolicyFragment();
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.flybits_con_fragment_privacy_policy, container, false);
        return view;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        this.webView = (WebView)view.findViewById(R.id.flybits_con_fragment_privacy_policy_web_view);
        this.loadingView = view.findViewById(R.id.flybits_con_settings_fragment_prgLoading);
        this.errorView = view.findViewById(R.id.flybits_con_fragment_privacy_policy_error_holder);
        this.errorRetryButton = (Button)view.findViewById(R.id.offline_fragment_retry_button);
        this.errorRetryButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Logger.d((String)"retry button clicked!");
                if (PrivacyPolicyFragment.this.url != null) {
                    PrivacyPolicyFragment.this.errorView.setVisibility(8);
                    PrivacyPolicyFragment.this.loadWebView(PrivacyPolicyFragment.this.url);
                }
            }
        });
        if (savedInstanceState == null) {
            this.url = FlybitsConcierge.with((Context)this.getActivity()).getConfiguration().getPrivacyPolicyUrl();
            if (this.url != null) {
                this.loadWebView(this.url);
            }
        } else {
            this.webView.restoreState(savedInstanceState);
            this.errorPresent = savedInstanceState.getBoolean("flybits_con_error_present");
            this.url = savedInstanceState.getString("flybits_con_url");
            if (this.errorPresent) {
                this.errorView.setVisibility(0);
                this.webView.setVisibility(8);
            } else {
                this.errorView.setVisibility(8);
                this.webView.setVisibility(0);
            }
        }
        super.onViewCreated(view, savedInstanceState);
    }

    private void loadWebView(String tncURL) {
        this.errorPresent = false;
        this.webView.loadUrl(tncURL);
        this.webView.setVisibility(8);
        this.loadingView.setVisibility(0);
        this.webView.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                PrivacyPolicyFragment.this.loadingView.setVisibility(8);
                if (PrivacyPolicyFragment.this.errorPresent) {
                    PrivacyPolicyFragment.this.displayErrorView();
                } else {
                    PrivacyPolicyFragment.this.showWebView();
                }
                super.onPageFinished(view, url);
                Logger.d((String)(PrivacyPolicyFragment.class.getSimpleName() + ": onPageFinished()"));
            }

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                PrivacyPolicyFragment.this.errorPresent = true;
                Logger.d((String)(PrivacyPolicyFragment.class.getSimpleName() + ": onReceivedError() error: " + error.toString()));
            }
        });
    }

    private void displayErrorView() {
        this.webView.setVisibility(8);
        this.errorView.setVisibility(0);
    }

    private void showWebView() {
        this.webView.setVisibility(0);
        this.errorView.setVisibility(8);
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString("flybits_con_url", this.url);
        outState.putBoolean("flybits_con_error_present", this.errorPresent);
        this.webView.saveState(outState);
    }
}

