package com.flybits.concierge.viewmodels

import android.arch.lifecycle.ViewModel
import android.arch.lifecycle.ViewModelProvider
import android.content.Context
import com.flybits.concierge.repository.CategoryDatabase
import com.flybits.concierge.repository.CategorySettingsRepository
import com.flybits.concierge.repository.ProjectSettingsGetter

class FeedHolderViewModelFactory(context: Context): ViewModelProvider.Factory {

    private val categorySettingsRepository: CategorySettingsRepository

    init {
        val categoryDao = CategoryDatabase.getInstance(context)!!.categoryDao()
        categorySettingsRepository = CategorySettingsRepository(categoryDao, ProjectSettingsGetter(context))
    }

    override fun <T : ViewModel?> create(modelClass: Class<T>): T {
        return if (modelClass.isAssignableFrom(FeedHolderViewModel::class.java)){
            FeedHolderViewModel(categorySettingsRepository) as T
        } else {
            throw IllegalArgumentException("ViewModel Not Found")
        }
    }
}