package com.flybits.concierge.models;

import android.os.Parcel;

import com.flybits.android.kernel.models.LocalizedValue;

public class Link extends BaseTemplate
{
    public Link()
    {
    }

    public LocalizedValue title;
    public LocalizedValue description;
    public String url;

    protected Link(Parcel in)
    {
        super(in);
        title = in.readParcelable(LocalizedValue.class.getClassLoader());
        description = in.readParcelable(LocalizedValue.class.getClassLoader());
        url = in.readString();
    }

    public static final Creator<Link> CREATOR = new Creator<Link>()
    {
        @Override
        public Link createFromParcel(Parcel in)
        {
            return new Link(in);
        }

        @Override
        public Link[] newArray(int size)
        {
            return new Link[size];
        }
    };

    @Override
    public int describeContents()
    {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags)
    {
        super.writeToParcel(dest,flags);
        dest.writeParcelable(title, flags);
        dest.writeParcelable(description, flags);
        dest.writeString(url);
    }
}
