package com.flybits.concierge.models;

import android.os.Parcel;
import android.os.Parcelable;

import com.flybits.android.kernel.models.PagedArray;
import com.flybits.concierge.enums.FeedView;

public class Articles extends BaseTemplate
{
    public PagedArray<Article> articles;

    public Articles()
    {
    }

    protected Articles(Parcel in)
    {
        super(in);
        articles = in.readParcelable(PagedArray.class.getClassLoader());
    }

    @Override
    public int describeContents()
    {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags)
    {
        super.writeToParcel(dest, flags);
        dest.writeParcelable(articles, flags);
    }

    public FeedView getType()
    {
        return FeedView.ARTICLES;
    }

    public static final Creator<Articles> CREATOR = new Creator<Articles>()
    {
        @Override
        public Articles createFromParcel(Parcel in)
        {
            return new Articles(in);
        }

        @Override
        public Articles[] newArray(int size)
        {
            return new Articles[size];
        }
    };
}
